/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.indexing.models;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import net.shrimpworks.unreal.packages.IntFile;
import org.unrealarchive.content.FileType;
import org.unrealarchive.indexing.Classifier;
import org.unrealarchive.indexing.Incoming;
import org.unrealarchive.indexing.IndexUtils;

public class ModelClassifier
implements Classifier {
    private static final List<String> INVALID_CLASSES = List.of("engine.mutator", "botpack.tournamentweapon", "botpack.tournamentgameinfo");
    static final String UNREAL_PLAYER_CLASS = "UnrealShare.UnrealiPlayer";
    static final String UT_PLAYER_CLASS = "Botpack.TournamentPlayer";
    static final String RUNE_PLAYER_CLASS = "RuneI.RunePlayer";
    static final String UT3_CHARACTER_DEF = "UTGame.UTCustomChar_Data";
    static final Pattern NAME_MATCH = Pattern.compile(".+?\\..+?");

    @Override
    public boolean classify(Incoming incoming) {
        Set<Incoming.IncomingFile> intFiles = incoming.files(FileType.INT);
        Set<Incoming.IncomingFile> animationFiles = incoming.files(FileType.ANIMATION);
        Set<Incoming.IncomingFile> codeFiles = incoming.files(FileType.CODE);
        Set<Incoming.IncomingFile> miscFiles = incoming.files(FileType.MAP, FileType.MUSIC, FileType.STATICMESH);
        Set<Incoming.IncomingFile> playerFiles = incoming.files(FileType.PLAYER);
        Set<Incoming.IncomingFile> upkFiles = incoming.files(FileType.PACKAGE);
        Set<Incoming.IncomingFile> iniFiles = incoming.files(FileType.INI);
        if (!miscFiles.isEmpty()) {
            return false;
        }
        if (!playerFiles.isEmpty() && !animationFiles.isEmpty()) {
            return this.ut2004Model(incoming, playerFiles);
        }
        if (!upkFiles.isEmpty() && !iniFiles.isEmpty()) {
            return this.ut3Model(incoming, iniFiles);
        }
        if (!intFiles.isEmpty() && !codeFiles.isEmpty()) {
            return this.utModel(incoming, intFiles);
        }
        return false;
    }

    private boolean utModel(Incoming incoming, Set<Incoming.IncomingFile> intFiles) {
        AtomicBoolean probablyNotAModel = new AtomicBoolean(false);
        AtomicBoolean seemsToBeAModel = new AtomicBoolean(false);
        IndexUtils.readIntFiles(incoming, intFiles).filter(Objects::nonNull).forEach(intFile -> {
            if (probablyNotAModel.get()) {
                return;
            }
            IntFile.Section section = intFile.section("public");
            if (section == null) {
                return;
            }
            IntFile.ListValue objects = section.asList("Object");
            for (IntFile.Value value : objects.values()) {
                if (!(value instanceof IntFile.MapValue)) continue;
                IntFile.MapValue mapVal = (IntFile.MapValue)value;
                if (INVALID_CLASSES.contains(mapVal.getOrDefault("MetaClass", "").toLowerCase())) {
                    probablyNotAModel.setOpaque(true);
                    return;
                }
                if (!mapVal.containsKey("Name") || !mapVal.containsKey("MetaClass") || !mapVal.containsKey("Description") || !mapVal.get("MetaClass").equalsIgnoreCase(UT_PLAYER_CLASS) && !mapVal.get("MetaClass").equalsIgnoreCase(UNREAL_PLAYER_CLASS) && !mapVal.get("MetaClass").equalsIgnoreCase(RUNE_PLAYER_CLASS)) continue;
                seemsToBeAModel.set(true);
            }
        });
        return !probablyNotAModel.get() && seemsToBeAModel.get();
    }

    private boolean ut2004Model(Incoming incoming, Set<Incoming.IncomingFile> playerFiles) {
        return !incoming.files(FileType.ANIMATION).isEmpty();
    }

    private boolean ut3Model(Incoming incoming, Set<Incoming.IncomingFile> iniFiles) {
        return IndexUtils.readIntFiles(incoming, iniFiles).filter(Objects::nonNull).anyMatch(intFile -> {
            IntFile.Section section = intFile.section(UT3_CHARACTER_DEF);
            if (section == null) {
                return false;
            }
            return section.keys().contains("+Characters");
        });
    }
}

