/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.indexing.models;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import net.shrimpworks.unreal.packages.IntFile;
import net.shrimpworks.unreal.packages.Package;
import net.shrimpworks.unreal.packages.PackageReader;
import net.shrimpworks.unreal.packages.entities.ExportedObject;
import net.shrimpworks.unreal.packages.entities.Name;
import net.shrimpworks.unreal.packages.entities.objects.Texture2D;
import net.shrimpworks.unreal.packages.entities.properties.ArrayProperty;
import net.shrimpworks.unreal.packages.entities.properties.ObjectProperty;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.FileType;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.Model;
import org.unrealarchive.indexing.Incoming;
import org.unrealarchive.indexing.IndexHandler;
import org.unrealarchive.indexing.IndexLog;
import org.unrealarchive.indexing.IndexResult;
import org.unrealarchive.indexing.IndexUtils;
import org.unrealarchive.indexing.models.ModelClassifier;
import org.unrealarchive.indexing.skins.SkinIndexHandler;

public class ModelIndexHandler
implements IndexHandler<Model> {
    @Override
    public void index(Incoming incoming, Addon current, Consumer<IndexResult<Model>> completed) {
        Model m = (Model)current;
        IndexLog log = incoming.log;
        HashSet<IndexResult.NewAttachment> attachments = new HashSet<IndexResult.NewAttachment>();
        String origName = m.name;
        m.models = new ArrayList();
        m.skins = new ArrayList();
        m.game = IndexUtils.game((Incoming)incoming).name;
        if (!incoming.files(FileType.PACKAGE).isEmpty()) {
            this.characterDescriptors(incoming).forEach(v -> {
                String maybeFaction = v.getOrDefault("Faction", "");
                if (!maybeFaction.isBlank()) {
                    m.models.add(maybeFaction + ": " + v.getOrDefault("CharName", "Unknown").trim());
                } else {
                    m.models.add(v.getOrDefault("CharName", "Unknown").trim());
                }
                if (m.name == null || m.name.equals(origName)) {
                    m.name = v.getOrDefault("CharName", "Unknown").trim();
                }
            });
        } else if (!incoming.files(FileType.PLAYER).isEmpty()) {
            HashSet meshes = new HashSet();
            SkinIndexHandler.playerDescriptors(incoming).forEach(p -> {
                if (p.containsKey("DefaultName")) {
                    if (p.containsKey("Mesh") && !meshes.contains(p.get("Mesh").trim())) {
                        m.models.add(p.get("DefaultName").trim());
                        meshes.add(p.get("Mesh").trim());
                    }
                    if (m.name == null || m.name.equals(origName)) {
                        m.name = p.get("DefaultName");
                    }
                    m.skins.add(p.get("DefaultName").trim());
                }
            });
        } else {
            ModelIndexHandler.modelDescriptors(incoming).forEach(d -> {
                if (d.containsKey("Description") && ModelClassifier.NAME_MATCH.matcher(d.get("Name")).matches() && !d.get("Description").trim().isBlank()) {
                    if (m.name == null || m.name.equals(origName)) {
                        m.name = d.get("Description");
                    }
                    m.models.add(d.get("Description").trim());
                    if (d.get("MetaClass").equalsIgnoreCase("RuneI.RunePlayer")) {
                        m.game = Games.RUNE.name;
                    } else if (d.get("MetaClass").equalsIgnoreCase("UnrealShare.UnrealiPlayer")) {
                        m.game = Games.UNREAL.name;
                    }
                }
            });
            SkinIndexHandler.skinDescriptors(incoming).forEach(d -> {
                if (d.containsKey("Description") && ModelClassifier.NAME_MATCH.matcher(d.get("Name")).matches()) {
                    if (m.name == null) {
                        m.name = d.get("Description");
                    }
                    m.skins.add(d.get("Description").trim());
                }
            });
        }
        m.models = m.models.stream().distinct().toList();
        m.skins = m.skins.stream().distinct().toList();
        m.author = IndexUtils.findAuthor(incoming);
        try {
            List<BufferedImage> images = IndexUtils.findImageFiles(incoming);
            SkinIndexHandler.findPortraits(incoming, images);
            this.findUt3Previews(incoming, images);
            IndexUtils.saveImages("%s_shot_%s_%d.png", (Addon)m, images, attachments);
        }
        catch (Throwable e) {
            log.log(IndexLog.EntryType.CONTINUE, "Failed to save images", e);
        }
        completed.accept(new IndexResult<Model>(m, attachments));
    }

    public static List<IntFile.MapValue> modelDescriptors(Incoming incoming) {
        return IndexUtils.readIntFiles(incoming, incoming.files(FileType.INT)).filter(Objects::nonNull).flatMap(intFile -> {
            ArrayList<IntFile.MapValue> vals = new ArrayList<IntFile.MapValue>();
            IntFile.Section section = intFile.section("public");
            if (section == null) {
                return Stream.empty();
            }
            IntFile.ListValue objects = section.asList("Object");
            for (IntFile.Value value : objects.values()) {
                IntFile.MapValue mapVal;
                if (!(value instanceof IntFile.MapValue) || !(mapVal = (IntFile.MapValue)value).containsKey("Name") || !mapVal.containsKey("MetaClass") || !mapVal.containsKey("Description") || !mapVal.get("MetaClass").equalsIgnoreCase("Botpack.TournamentPlayer") && !mapVal.get("MetaClass").equalsIgnoreCase("UnrealShare.UnrealiPlayer") && !mapVal.get("MetaClass").equalsIgnoreCase("RuneI.RunePlayer")) continue;
                vals.add(mapVal);
            }
            return vals.stream();
        }).filter(Objects::nonNull).toList();
    }

    private List<IntFile.MapValue> characterDescriptors(Incoming incoming) {
        return IndexUtils.readIntFiles(incoming, incoming.files(FileType.INI)).filter(Objects::nonNull).flatMap(intFile -> {
            IntFile.Section section = intFile.section("UTGame.UTCustomChar_Data");
            if (section == null) {
                return Stream.empty();
            }
            return section.asList("+Characters").values().stream().filter(v -> v instanceof IntFile.MapValue).map(v -> (IntFile.MapValue)v).filter(v -> v.containsKey("CharName"));
        }).filter(Objects::nonNull).toList();
    }

    private void findUt3Previews(Incoming incoming, List<BufferedImage> images) {
        this.characterDescriptors(incoming).stream().filter(c -> c.containsKey("PreviewImageMarkup")).forEach(c -> {
            Matcher matcher = IndexUtils.UT3_SCREENSHOT_MATCH.matcher(c.get("PreviewImageMarkup"));
            if (matcher.find()) {
                String pkgName = matcher.group(1);
                incoming.files(FileType.PACKAGE).stream().filter(f -> Util.plainName((String)f.fileName()).equalsIgnoreCase(pkgName)).findFirst().ifPresent(f -> {
                    try (Package pkg = new Package(new PackageReader(f.asChannel()));){
                        ExportedObject export = pkg.objectByName(new Name(matcher.group(3)));
                        if (export == null) {
                            return;
                        }
                        net.shrimpworks.unreal.packages.entities.objects.Object object = export.object();
                        if (object instanceof Texture2D) {
                            images.add(IndexUtils.screenshotFromObject(pkg, object));
                        }
                        if (object.className().equals("Material") && object.property("ReferencedTextures") instanceof ArrayProperty) {
                            ((ArrayProperty)object.property((String)"ReferencedTextures")).values.forEach(t -> {
                                net.shrimpworks.unreal.packages.entities.objects.Object tex;
                                if (t instanceof ObjectProperty && (tex = pkg.objectByRef(((ObjectProperty)t).value).object()) instanceof Texture2D) {
                                    images.add(IndexUtils.screenshotFromObject(pkg, tex));
                                }
                            });
                        }
                    }
                    catch (Throwable e) {
                        incoming.log.log(IndexLog.EntryType.CONTINUE, "Failed to extract UE3 images", e);
                    }
                });
            }
        });
    }

    public static class ModelIndexHandlerFactory
    implements IndexHandler.IndexHandlerFactory<Model> {
        @Override
        public IndexHandler<Model> get() {
            return new ModelIndexHandler();
        }
    }
}

