/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.indexing.mutators;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.shrimpworks.unreal.packages.IntFile;
import org.unrealarchive.content.FileType;
import org.unrealarchive.content.NameDescription;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.Mutator;
import org.unrealarchive.indexing.Incoming;
import org.unrealarchive.indexing.IndexHandler;
import org.unrealarchive.indexing.IndexLog;
import org.unrealarchive.indexing.IndexResult;
import org.unrealarchive.indexing.IndexUtils;

public class MutatorIndexHandler
implements IndexHandler<Mutator> {
    @Override
    public void index(Incoming incoming, Addon current, Consumer<IndexResult<Mutator>> completed) {
        Mutator m = (Mutator)current;
        IndexLog log = incoming.log;
        HashSet<IndexResult.NewAttachment> attachments = new HashSet<IndexResult.NewAttachment>();
        m.name = IndexUtils.friendlyName(m.name);
        Set<Incoming.IncomingFile> uclFiles = incoming.files(FileType.UCL);
        Set<Incoming.IncomingFile> intFiles = incoming.files(FileType.INT);
        Set<Incoming.IncomingFile> iniFiles = incoming.files(FileType.INI);
        if (!uclFiles.isEmpty()) {
            this.readUclFiles(incoming, m, uclFiles, intFiles);
        } else if (!intFiles.isEmpty()) {
            this.readIntFiles(incoming, m, intFiles);
        }
        if (m.mutators.isEmpty() && !iniFiles.isEmpty()) {
            this.readIniFiles(incoming, m, iniFiles);
        }
        if (m.mutators.size() == 1) {
            m.name = ((NameDescription)m.mutators.getFirst()).name;
            m.description = ((NameDescription)m.mutators.getFirst()).description;
        }
        m.mutators = m.mutators.stream().distinct().toList();
        m.game = IndexUtils.game((Incoming)incoming).name;
        m.author = IndexUtils.findAuthor(incoming, true);
        try {
            List<BufferedImage> images = IndexUtils.findImageFiles(incoming);
            IndexUtils.saveImages("%s_shot_%s_%d.png", (Addon)m, images, attachments);
        }
        catch (IOException e) {
            log.log(IndexLog.EntryType.CONTINUE, "Failed to save images", e);
        }
        completed.accept(new IndexResult<Mutator>(m, attachments));
    }

    private void readUclFiles(Incoming incoming, Mutator mutator, Set<Incoming.IncomingFile> uclFiles, Set<Incoming.IncomingFile> intFiles) {
        IndexUtils.readIntFiles(incoming, uclFiles, true).filter(Objects::nonNull).forEach(intFile -> {
            IntFile.Section section = intFile.section("root");
            if (section == null) {
                return;
            }
            IntFile.ListValue mutators = section.asList("Mutator");
            for (Object value : mutators.values()) {
                IntFile.MapValue mapVal;
                if (!(value instanceof IntFile.MapValue) || !(mapVal = (IntFile.MapValue)value).containsKey("FallbackName")) continue;
                mutator.mutators.add(new NameDescription(mapVal.get("FallbackName"), mapVal.getOrDefault("FallbackDesc", "")));
            }
            IntFile.ListValue weapons = section.asList("Weapon");
            for (IntFile.Value value : weapons.values()) {
                IntFile.MapValue mapVal;
                if (!(value instanceof IntFile.MapValue) || !(mapVal = (IntFile.MapValue)value).containsKey("FallbackName")) continue;
                mutator.weapons.add(new NameDescription(mapVal.get("FallbackName"), mapVal.getOrDefault("FallbackDesc", "")));
            }
            IntFile.ListValue vehicles = section.asList("Vehicle");
            for (IntFile.Value value : vehicles.values()) {
                IntFile.MapValue mapVal;
                if (!(value instanceof IntFile.MapValue) || !(mapVal = (IntFile.MapValue)value).containsKey("FallbackName")) continue;
                mutator.vehicles.add(new NameDescription(mapVal.get("FallbackName"), mapVal.getOrDefault("FallbackDesc", "")));
            }
        });
        IndexUtils.readIntFiles(incoming, intFiles).filter(Objects::nonNull).forEach(intFile -> {
            IntFile.Section section = intFile.section("public");
            if (section == null) {
                return;
            }
            IntFile.ListValue objects = section.asList("Object");
            for (IntFile.Value value : objects.values()) {
                IntFile.MapValue mapVal;
                if (!(value instanceof IntFile.MapValue) || !(mapVal = (IntFile.MapValue)value).containsKey("MetaClass") || !"Xinterface.GUIUserKeyBinding".equalsIgnoreCase(mapVal.get("MetaClass"))) continue;
                mutator.hasKeybinds = true;
            }
        });
    }

    private void readIntFiles(Incoming incoming, Mutator mutator, Set<Incoming.IncomingFile> intFiles) {
        IndexUtils.readIntFiles(incoming, intFiles).filter(Objects::nonNull).forEach(intFile -> {
            IntFile.Section section = intFile.section("public");
            if (section == null) {
                return;
            }
            IntFile.ListValue objects = section.asList("Object");
            for (IntFile.Value value : objects.values()) {
                String[] className;
                IntFile.MapValue mapVal;
                if (!(value instanceof IntFile.MapValue) || !(mapVal = (IntFile.MapValue)value).containsKey("MetaClass")) continue;
                String[] stringArray = className = mapVal.get("Name") == null ? new String[]{} : mapVal.get("Name").split("\\.", 2);
                if ("Engine.Mutator".equalsIgnoreCase(mapVal.get("MetaClass"))) {
                    if (mapVal.get("Description") != null) {
                        mutator.mutators.add(new NameDescription(mapVal.get("Description")));
                        continue;
                    }
                    if (className.length != 2) continue;
                    mutator.mutators.add(new NameDescription(className[1]));
                    continue;
                }
                if ("Botpack.TournamentWeapon".equalsIgnoreCase(mapVal.get("MetaClass"))) {
                    if (mapVal.get("Description") == null && className.length == 2 && intFile.section(className[1]) != null) {
                        IntFile.Section weapSection = intFile.section(className[1]);
                        if (weapSection.value("WeaponDescription") == null) continue;
                        mutator.weapons.add(new NameDescription(className[1], weapSection.value("WeaponDescription").toString().replace("\\n", "|")));
                        continue;
                    }
                    if (mapVal.get("Description") != null) {
                        mutator.weapons.add(new NameDescription(mapVal.get("Description")));
                        continue;
                    }
                    if (className.length != 2) continue;
                    mutator.weapons.add(new NameDescription(className[1]));
                    continue;
                }
                if ("UTMenu.UTExtraKeyBindings".equalsIgnoreCase(mapVal.get("MetaClass"))) {
                    mutator.hasKeybinds = true;
                    continue;
                }
                if (!"UMenu.UMenuModMenuItem".equalsIgnoreCase(mapVal.get("MetaClass"))) continue;
                mutator.hasConfigMenu = true;
            }
        });
    }

    private void readIniFiles(Incoming incoming, Mutator mutator, Set<Incoming.IncomingFile> iniFiles) {
        IndexUtils.readIntFiles(incoming, iniFiles).filter(Objects::nonNull).forEach(iniFile -> iniFile.sections().forEach(name -> {
            IntFile.Section section = iniFile.section(name);
            if (name.toLowerCase().endsWith("UTUIDataProvider_Mutator".toLowerCase())) {
                mutator.mutators.add(MutatorIndexHandler.sectionToNameDesc(section, mutator.name));
            } else if (name.toLowerCase().endsWith("UTUIDataProvider_Weapon".toLowerCase())) {
                mutator.weapons.add(MutatorIndexHandler.sectionToNameDesc(section, mutator.name));
            } else if (name.toLowerCase().endsWith("UTUIDataProvider_Vehicle".toLowerCase())) {
                mutator.vehicles.add(MutatorIndexHandler.sectionToNameDesc(section, mutator.name));
            }
            if (section.value("UIConfigScene") != null && !section.value("UIConfigScene").toString().isBlank()) {
                mutator.hasConfigMenu = true;
            }
        }));
    }

    public static NameDescription sectionToNameDesc(IntFile.Section section, String defaultName) {
        IntFile.Value friendlyName = section.value("FriendlyName");
        IntFile.Value description = section.value("Description");
        String nameString = defaultName;
        String descString = "";
        if (friendlyName != null) {
            nameString = friendlyName.toString();
        }
        if (description != null) {
            descString = description.toString();
        }
        return new NameDescription(nameString, descString);
    }

    public static class MutatorIndexHandlerFactory
    implements IndexHandler.IndexHandlerFactory<Mutator> {
        @Override
        public IndexHandler<Mutator> get() {
            return new MutatorIndexHandler();
        }
    }
}

