/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.indexing.skins;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.shrimpworks.unreal.packages.IntFile;
import org.unrealarchive.content.FileType;
import org.unrealarchive.indexing.Classifier;
import org.unrealarchive.indexing.Incoming;
import org.unrealarchive.indexing.IndexUtils;

public class SkinClassifier
implements Classifier {
    public static final Pattern NAME_MATCH = Pattern.compile(".+?\\..{4}\\d");
    static final Pattern NAME_MATCH_UNREAL = Pattern.compile(".+?\\.(.+?)");
    static final Pattern FACE_MATCH = Pattern.compile(".+?\\..{4}\\d[a-zA-Z0-9-_]+");
    static final Pattern FACE_PORTRAIT_MATCH = Pattern.compile("(.+?)\\.(.+?5[a-zA-Z0-9]+)");
    static final Pattern TEAM_MATCH = Pattern.compile(".+?\\..+?\\dT_\\d", 2);

    @Override
    public boolean classify(Incoming incoming) {
        Set<Incoming.IncomingFile> intFiles = incoming.files(FileType.INT);
        Set<Incoming.IncomingFile> playerFiles = incoming.files(FileType.PLAYER);
        Set<Incoming.IncomingFile> codeFiles = incoming.files(FileType.CODE);
        if (!codeFiles.isEmpty()) {
            return false;
        }
        if (!incoming.files(FileType.MAP).isEmpty()) {
            return false;
        }
        if (incoming.files(FileType.TEXTURE).isEmpty()) {
            return false;
        }
        if (!playerFiles.isEmpty()) {
            return this.ut2004Skin(incoming, playerFiles);
        }
        if (!intFiles.isEmpty()) {
            return this.utSkin(incoming, intFiles) || this.unrealSkin(incoming, intFiles);
        }
        return false;
    }

    private boolean utSkin(Incoming incoming, Set<Incoming.IncomingFile> intFiles) {
        AtomicBoolean seemsToBeASkin = new AtomicBoolean(false);
        IndexUtils.readIntFiles(incoming, intFiles).filter(Objects::nonNull).forEach(intFile -> {
            IntFile.Section section = intFile.section("public");
            if (section == null) {
                return;
            }
            IntFile.ListValue objects = section.asList("Object");
            for (IntFile.Value value : objects.values()) {
                Matcher m;
                if (!(value instanceof IntFile.MapValue) || !((IntFile.MapValue)value).containsKey("Name") || !((IntFile.MapValue)value).containsKey("Class") || !((IntFile.MapValue)value).containsKey("Description") || !((IntFile.MapValue)value).get("Class").equalsIgnoreCase("Texture") || !(m = NAME_MATCH.matcher(((IntFile.MapValue)value).get("Name"))).matches()) continue;
                seemsToBeASkin.set(true);
                return;
            }
        });
        return seemsToBeASkin.get();
    }

    private boolean unrealSkin(Incoming incoming, Set<Incoming.IncomingFile> intFiles) {
        AtomicBoolean seemsToBeASkin = new AtomicBoolean(false);
        IndexUtils.readIntFiles(incoming, intFiles).filter(Objects::nonNull).forEach(intFile -> {
            IntFile.Section section = intFile.section("public");
            if (section == null) {
                return;
            }
            IntFile.ListValue objects = section.asList("Object");
            for (IntFile.Value value : objects.values()) {
                Matcher m;
                if (!(value instanceof IntFile.MapValue) || ((IntFile.MapValue)value).containsKey("Description") || !((IntFile.MapValue)value).containsKey("Name") || !((IntFile.MapValue)value).containsKey("Class") || !((IntFile.MapValue)value).get("Class").equalsIgnoreCase("Texture") || !(m = NAME_MATCH_UNREAL.matcher(((IntFile.MapValue)value).get("Name"))).matches()) continue;
                seemsToBeASkin.set(true);
                return;
            }
        });
        return seemsToBeASkin.get();
    }

    private boolean ut2004Skin(Incoming incoming, Set<Incoming.IncomingFile> playerFiles) {
        return incoming.files(FileType.ANIMATION).isEmpty();
    }
}

