/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.indexing.voices;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.shrimpworks.unreal.packages.IntFile;
import org.unrealarchive.content.FileType;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.Voice;
import org.unrealarchive.indexing.Incoming;
import org.unrealarchive.indexing.IndexHandler;
import org.unrealarchive.indexing.IndexLog;
import org.unrealarchive.indexing.IndexResult;
import org.unrealarchive.indexing.IndexUtils;
import org.unrealarchive.indexing.voices.VoiceClassifier;

public class VoiceIndexHandler
implements IndexHandler<Voice> {
    @Override
    public void index(Incoming incoming, Addon current, Consumer<IndexResult<Voice>> completed) {
        Voice v = (Voice)current;
        IndexLog log = incoming.log;
        HashSet<IndexResult.NewAttachment> attachments = new HashSet<IndexResult.NewAttachment>();
        String origName = v.name;
        v.voices = this.voiceNames(incoming);
        v.voices = v.voices.stream().map(n -> {
            n = n.replaceAll("\"", "");
            if (v.name == null || v.name.equalsIgnoreCase(origName)) {
                v.name = n;
            }
            return n;
        }).distinct().toList();
        v.game = IndexUtils.game((Incoming)incoming).name;
        v.author = IndexUtils.findAuthor(incoming, true);
        try {
            List<BufferedImage> images = IndexUtils.findImageFiles(incoming);
            IndexUtils.saveImages("%s_shot_%s_%d.png", (Addon)v, images, attachments);
        }
        catch (IOException e) {
            log.log(IndexLog.EntryType.CONTINUE, "Failed to save images", e);
        }
        completed.accept(new IndexResult<Voice>(v, attachments));
    }

    private List<String> voiceNames(Incoming incoming) {
        return IndexUtils.readIntFiles(incoming, incoming.files(FileType.INT)).filter(Objects::nonNull).flatMap(intFile -> {
            IntFile.Section section = intFile.section("public");
            if (section == null) {
                return Stream.empty();
            }
            HashSet<String> foundVoices = new HashSet<String>();
            IntFile.ListValue objects = section.asList("Object");
            for (IntFile.Value value : objects.values()) {
                IntFile.MapValue mapVal = (IntFile.MapValue)value;
                if (!mapVal.containsKey("MetaClass")) continue;
                String[] voiceClass = mapVal.getOrDefault("Name", "Package.Unknown").split("\\.");
                String maybeName = voiceClass[voiceClass.length - 1];
                if (mapVal.get("MetaClass").equalsIgnoreCase("XGame.xVoicePack")) {
                    IntFile.Value nameVal;
                    IntFile.Section nameSection = intFile.section(maybeName);
                    if (nameSection != null && (nameVal = nameSection.value("VoicePackName")) instanceof IntFile.SimpleValue) {
                        maybeName = ((IntFile.SimpleValue)nameVal).value();
                    }
                    foundVoices.add(maybeName);
                    continue;
                }
                if (!VoiceClassifier.UT_VOICE_MATCH.matcher(mapVal.get("MetaClass")).matches()) continue;
                foundVoices.add(mapVal.getOrDefault("Description", maybeName));
            }
            return foundVoices.stream();
        }).filter(Objects::nonNull).toList();
    }

    public static class VoiceIndexHandlerFactory
    implements IndexHandler.IndexHandlerFactory<Voice> {
        @Override
        public IndexHandler<Voice> get() {
            return new VoiceIndexHandler();
        }
    }
}

