/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.mirror;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unrealarchive.common.Reflect;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.ContentEntity;
import org.unrealarchive.content.Download;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.mirror.Progress;

public class LocalMirrorClient
implements Consumer<Downloader> {
    private static final int RETRY_LIMIT = 4;
    private final int concurrency;
    private final ExecutorService executor;
    private final Progress progress;
    private Deque<Addon> mirrorQueue;
    private Deque<Addon> retryQueue;
    private Path output;
    private long totalCount;
    private volatile CountDownLatch counter;
    private volatile Thread mirrorThread;

    public LocalMirrorClient(int concurrency, Progress progress) {
        this.concurrency = concurrency;
        this.progress = progress;
        this.executor = Executors.newFixedThreadPool(concurrency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void mirror(Collection<Addon> mirrorContent, Path output) {
        this.mirrorThread = Thread.currentThread();
        this.mirrorQueue = new ConcurrentLinkedDeque<Addon>(mirrorContent);
        this.retryQueue = new ConcurrentLinkedDeque<Addon>();
        this.output = output;
        this.totalCount = mirrorContent.size();
        try {
            for (int retryCount = 0; retryCount <= 4 && !this.mirrorQueue.isEmpty(); ++retryCount) {
                if (retryCount > 0) {
                    System.err.printf("%nA total of %d download(s) failed, retrying (%d/%d)...%n", this.mirrorQueue.size(), retryCount, 4);
                }
                this.counter = new CountDownLatch(this.mirrorQueue.size());
                for (int i = 0; i < this.concurrency; ++i) {
                    this.next();
                }
                this.counter.await();
                if (this.retryQueue.isEmpty()) continue;
                this.mirrorQueue = this.retryQueue;
                this.retryQueue = new ConcurrentLinkedDeque<Addon>();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.mirrorThread = null;
        }
    }

    public void cancel() {
        this.executor.shutdownNow();
        if (this.mirrorThread != null) {
            this.mirrorThread.interrupt();
            this.mirrorThread = null;
        }
    }

    @Override
    public void accept(Downloader downloader) {
        this.progress.progress(this.totalCount, this.mirrorQueue.size(), (ContentEntity<?>)downloader.content);
        this.counter.countDown();
        this.next();
    }

    private void next() {
        Addon c = this.mirrorQueue.poll();
        if (c != null) {
            this.executor.submit(new Downloader(c, this.outputPath(c, this.output), this, this.retryQueue));
        }
    }

    protected Path outputPath(Addon c, Path output) {
        String outPath = output.toString();
        Pattern p = Pattern.compile("\\{([A-Za-z]+)}");
        Matcher m = p.matcher(outPath);
        if (!m.find()) {
            return c.contentPath(output);
        }
        Map fields = Reflect.classLowercaseFields((Object)c);
        m.reset();
        while (m.find()) {
            String strVal = "unknown";
            try {
                Object val;
                Field field = (Field)fields.get(m.group(1).toLowerCase());
                if (field != null && (val = field.get(c)) != null && (strVal = val.toString()) == null) {
                    strVal = "unknown";
                }
            }
            catch (ClassCastException | IllegalAccessException e) {
                strVal = "unknown";
            }
            outPath = outPath.replace("{" + m.group(1) + "}", Util.safeFileName((String)strVal));
        }
        return output.resolve(outPath);
    }

    public static class Downloader
    implements Runnable {
        public final Addon content;
        public final Path destination;
        private final Path output;
        private final Consumer<Downloader> done;
        private final Deque<Addon> retryQueue;

        public Downloader(Addon c, Path output, Consumer<Downloader> done) {
            this(c, output, done, null);
        }

        public Downloader(Addon c, Path output, Consumer<Downloader> done, Deque<Addon> retryQueue) {
            this.retryQueue = retryQueue;
            this.content = c;
            this.output = output;
            this.done = done;
            try {
                this.destination = Files.createDirectories(output, new FileAttribute[0]).resolve(this.content.originalFilename);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create directories for content " + this.content.originalFilename);
            }
        }

        @Override
        public void run() {
            try {
                Download dl = this.content.directDownload();
                if (dl == null) {
                    return;
                }
                if (Files.exists(this.destination, new LinkOption[0]) && Files.size(this.destination) == (long)this.content.fileSize) {
                    return;
                }
                Util.downloadTo((String)dl.url, (Path)this.destination);
            }
            catch (Throwable t) {
                if (this.retryQueue != null) {
                    System.err.printf("%nFailed to download content %s: %s (queued for retry)%n", this.output, t);
                    this.retryQueue.add(this.content);
                }
            }
            finally {
                if (this.done != null) {
                    this.done.accept(this);
                }
            }
        }
    }
}

