/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.indexing;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.unrealarchive.common.YAML;
import org.unrealarchive.content.Download;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.SimpleAddonRepository;
import org.unrealarchive.indexing.IndexResult;
import org.unrealarchive.indexing.Submission;
import org.unrealarchive.storage.DataStore;

public class ContentManager {
    private final SimpleAddonRepository repo;
    private final DataStore contentStore;
    private final DataStore imageStore;
    private final Set<String> changes;

    public ContentManager(SimpleAddonRepository repo, DataStore contentStore, DataStore imageStore) {
        this.repo = repo;
        this.contentStore = contentStore;
        this.imageStore = imageStore;
        this.changes = new HashSet<String>();
    }

    public SimpleAddonRepository repo() {
        return this.repo;
    }

    public Addon checkout(String hash) {
        Addon out = this.repo.forHash(hash);
        if (out != null) {
            try {
                return (Addon)YAML.fromString((String)YAML.toString((Object)out), Addon.class);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot clone content " + String.valueOf(out));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkin(IndexResult<? extends Addon> indexed, Submission submission) throws IOException {
        Addon current = this.repo.forHash(((Addon)indexed.content).hash);
        if (current == null || !indexed.content.equals((Object)current) || !indexed.files.isEmpty()) {
            Path next = indexed.content.contentPath(this.repo.path());
            for (IndexResult.NewAttachment file : indexed.files) {
                try {
                    String uploadPath = this.repo.path().relativize(next.resolve(file.name())).toString();
                    if (file.type() != Addon.AttachmentType.IMAGE) continue;
                    this.imageStore.store(file.path(), uploadPath, (fileUrl, ex) -> {
                        if (ex == null && fileUrl != null) {
                            ((Addon)indexed.content).attachments.add(new Addon.Attachment(file.type(), file.name(), fileUrl));
                        } else {
                            ex.printStackTrace();
                        }
                    });
                }
                finally {
                    Files.deleteIfExists(file.path());
                }
            }
            if (submission != null && ((Addon)indexed.content).downloads.stream().noneMatch(d -> d.direct)) {
                String uploadPath = this.repo.path().relativize(next.resolve(submission.filePath.getFileName())).toString();
                this.contentStore.store(submission.filePath, uploadPath, (fileUrl, ex) -> {
                    if (ex != null || fileUrl == null) {
                        throw new RuntimeException((Throwable)ex);
                    }
                    ((Addon)indexed.content).downloads.add(new Download(fileUrl, true, Download.DownloadState.OK));
                });
            }
            this.repo.put(indexed.content);
            this.changes.add(((Addon)indexed.content).hash);
            return true;
        }
        return false;
    }
}

