/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.indexing;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.imageio.ImageIO;
import net.shrimpworks.unreal.packages.IntFile;
import net.shrimpworks.unreal.packages.Package;
import net.shrimpworks.unreal.packages.PackageReader;
import net.shrimpworks.unreal.packages.entities.ExportedObject;
import net.shrimpworks.unreal.packages.entities.objects.Object;
import net.shrimpworks.unreal.packages.entities.properties.Property;
import net.shrimpworks.unreal.packages.entities.properties.StringProperty;
import org.unrealarchive.common.Platform;
import org.unrealarchive.common.Util;
import org.unrealarchive.common.YAML;
import org.unrealarchive.content.Download;
import org.unrealarchive.content.FileType;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.NameDescription;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.GameType;
import org.unrealarchive.content.addons.GameTypeRepository;
import org.unrealarchive.indexing.Incoming;
import org.unrealarchive.indexing.IndexUtils;
import org.unrealarchive.indexing.Submission;
import org.unrealarchive.indexing.mutators.MutatorIndexHandler;
import org.unrealarchive.storage.DataStore;

public class GameTypeManager {
    private static final String REMOTE_ROOT = "gametypes";
    private final GameTypeRepository repo;
    private final DataStore contentStore;
    private final DataStore imageStore;

    public GameTypeManager(GameTypeRepository repo, DataStore contentStore, DataStore imageStore) {
        this.repo = repo;
        this.contentStore = contentStore;
        this.imageStore = imageStore;
    }

    public GameTypeRepository repo() {
        return this.repo;
    }

    public GameType checkout(GameType gameType) {
        try {
            GameType clone = (GameType)YAML.fromString((String)YAML.toString((java.lang.Object)gameType), GameType.class);
            clone.variation = gameType.isVariation();
            return clone;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot clone GameType " + gameType.name());
        }
    }

    public void checkin(GameType gameType) {
        try {
            this.repo.put(gameType);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot store GameType " + gameType.name());
        }
    }

    public void addRelease(Games game, String gameType, String releaseName, Path localFile, Map<String, String> params, BiConsumer<GameType, GameType.Release> complete) throws IOException {
        GameType gt = Optional.ofNullable(this.repo.findGametype(game, gameType)).or(() -> {
            this.repo.create(game, gameType, created -> {
                created.releases.clear();
                created.links.clear();
                created.credits.clear();
                created.description = "";
                created.titleImage = "";
                created.bannerImage = "";
            });
            return Optional.ofNullable(this.repo.findGametype(game, gameType));
        }).orElseThrow();
        GameType.Release rel = gt.releases.stream().filter(r -> r.title.equalsIgnoreCase(releaseName)).findFirst().orElseGet(() -> {
            GameType.Release release = new GameType.Release();
            release.title = releaseName;
            release.version = params.getOrDefault("version", releaseName);
            release.releaseDate = params.getOrDefault("releaseDate", release.releaseDate);
            release.description = params.getOrDefault("description", release.description);
            gt.releases.add(release);
            return release;
        });
        GameType.ReleaseFile file = new GameType.ReleaseFile();
        file.localFile = localFile.toString();
        file.originalFilename = Util.fileName((Path)localFile);
        file.platform = Platform.valueOf((String)params.getOrDefault("platform", file.platform.name()));
        file.title = params.getOrDefault("title", releaseName);
        rel.files.add(file);
        this.repo.put(gt);
        complete.accept(gt, rel);
    }

    public void sync() {
        this.syncReleases();
    }

    public void index(GameType gameType, GameType.Release release, GameType.ReleaseFile releaseFile) {
        GameType clone = this.checkout(gameType);
        GameType.Release releaseClone = clone.releases.stream().filter(r -> r.equals((java.lang.Object)release)).findFirst().get();
        GameType.ReleaseFile releaseFileClone = releaseClone.files.stream().filter(f -> f.equals((java.lang.Object)releaseFile)).findFirst().get();
        this.indexReleases(clone, releaseFileClone, this.imageStore);
        this.checkin(clone);
    }

    public void syncReleases() {
        this.repo.all().stream().filter(g -> g.releases.stream().flatMap(m -> m.files.stream()).anyMatch(r -> !r.synced)).forEach(this::syncReleases);
    }

    private void syncReleases(GameType gameType) {
        System.out.println("Syncing gametype: " + gameType.name());
        GameType clone = this.checkout(gameType);
        boolean[] success = new boolean[]{false};
        clone.releases.stream().flatMap(r -> r.files.stream()).filter(f -> !f.synced).forEach(r -> {
            Path f = Paths.get(r.localFile, new String[0]);
            this.syncReleaseFile(clone, (GameType.ReleaseFile)r, f, success);
        });
        if (success[0]) {
            this.checkin(clone);
        }
    }

    public void syncReleaseFile(GameType gameType, GameType.ReleaseFile r, Path localFile, boolean[] success) {
        System.out.println(" - sync files for release " + r.title);
        if (!Files.exists(localFile, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Local file %s not found!", localFile));
        }
        if (!r.synced) {
            try (Incoming incoming = new Incoming(new Submission(localFile, new String[0]));){
                System.out.println(" - get file details for " + String.valueOf(localFile.getFileName()));
                incoming.prepare();
                r.otherFiles = 0;
                r.files.clear();
                for (Incoming.IncomingFile i : incoming.files(FileType.ALL)) {
                    if (!FileType.important((String)i.file)) {
                        ++r.otherFiles;
                        continue;
                    }
                    r.files.add(new Addon.ContentFile(i.fileName(), i.fileSize(), i.hash()));
                }
                r.dependencies = IndexUtils.dependencies(Games.byName((String)gameType.game), incoming);
            }
            catch (Exception e) {
                System.err.printf("Could not read files and dependencies for release file %s%n", localFile);
            }
        }
        try {
            System.out.println(" - storing file " + String.valueOf(localFile.getFileName()));
            this.storeReleaseFile(gameType, r, localFile, success);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to sync file %s: %s%n", r.localFile, e));
        }
    }

    private void storeReleaseFile(GameType gameType, GameType.ReleaseFile releaseFile, Path localFile, boolean[] success) throws IOException {
        this.contentStore.store(localFile, String.join((CharSequence)"/", this.remotePath(gameType), localFile.getFileName().toString()), (url, ex) -> {
            System.out.println(" - stored as " + url);
            try {
                if (releaseFile.downloads.stream().noneMatch(dl -> dl.url.equals(url))) {
                    releaseFile.downloads.add(new Download(url, true, Download.DownloadState.OK));
                }
                if (!releaseFile.synced) {
                    releaseFile.fileSize = Files.size(localFile);
                    releaseFile.hash = Util.hash((Path)localFile);
                    releaseFile.originalFilename = Util.fileName((Path)localFile);
                    releaseFile.synced = true;
                }
                success[0] = true;
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Failed to update gametype definition %s: %s%n", gameType.name(), e));
            }
        });
    }

    private void indexReleases(GameType gameType, GameType.ReleaseFile releaseFile, DataStore imagesStore) {
        Path[] f = new Path[]{Paths.get(releaseFile.localFile, new String[0])};
        if (!Files.exists(f[0], new LinkOption[0])) {
            System.out.printf("Downloading %s (%dKB)%n", releaseFile.originalFilename, releaseFile.fileSize / 1024L);
            try {
                f[0] = Util.downloadTo((String)releaseFile.directDownload().url, (Path)Files.createTempDirectory("ua-gametype", new FileAttribute[0]).resolve(releaseFile.originalFilename));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Could not download file %s", releaseFile), e);
            }
        }
        try (Incoming incoming = new Incoming(new Submission(f[0], new String[0]));){
            incoming.prepare();
            gameType.gameTypes = this.findGameTypes(incoming);
            gameType.mutators = this.findMutators(incoming);
            gameType.maps = this.findMaps(incoming, gameType, imagesStore);
        }
        catch (IOException e) {
            System.err.printf("Could not read files and dependencies for release file %s%n", f[0]);
            e.printStackTrace();
        }
    }

    private List<NameDescription> findGameTypes(Incoming incoming) {
        Set<Incoming.IncomingFile> uclFiles = incoming.files(FileType.UCL);
        Set<Incoming.IncomingFile> intFiles = incoming.files(FileType.INT);
        if (!uclFiles.isEmpty()) {
            return IndexUtils.readIntFiles(incoming, uclFiles, true).filter(Objects::nonNull).flatMap(intFile -> {
                IntFile.Section section = intFile.section("root");
                if (section == null) {
                    return null;
                }
                IntFile.ListValue game = section.asList("Game");
                return game.values().stream();
            }).filter(Objects::nonNull).filter(v -> v instanceof IntFile.MapValue && ((IntFile.MapValue)v).value().containsKey("FallbackName")).map(v -> (IntFile.MapValue)v).map(mapVal -> new NameDescription(mapVal.get("FallbackName"), mapVal.getOrDefault("FallbackDesc", ""))).sorted(Comparator.comparing(a -> a.name)).toList();
        }
        if (!intFiles.isEmpty()) {
            return IndexUtils.readIntFiles(incoming, intFiles).filter(Objects::nonNull).flatMap(intFile -> {
                IntFile.Section section = intFile.section("public");
                if (section == null) {
                    return null;
                }
                IntFile.ListValue prefs = section.asList("Preferences");
                return prefs.values().stream();
            }).filter(Objects::nonNull).filter(v -> v instanceof IntFile.MapValue && ((IntFile.MapValue)v).value().containsKey("Caption") && ((IntFile.MapValue)v).value().containsKey("Parent")).map(v -> (IntFile.MapValue)v).filter(mapVal -> mapVal.get("Parent").equalsIgnoreCase("Game Types")).map(mapVal -> new NameDescription(mapVal.get("Caption"))).sorted(Comparator.comparing(a -> a.name)).toList();
        }
        return List.of();
    }

    private List<NameDescription> findMutators(Incoming incoming) {
        Set<Incoming.IncomingFile> uclFiles = incoming.files(FileType.UCL);
        Set<Incoming.IncomingFile> intFiles = incoming.files(FileType.INT);
        Set<Incoming.IncomingFile> iniFiles = incoming.files(FileType.INI);
        if (!uclFiles.isEmpty()) {
            return IndexUtils.readIntFiles(incoming, uclFiles, true).filter(Objects::nonNull).flatMap(intFile -> {
                IntFile.Section section = intFile.section("root");
                if (section == null) {
                    return null;
                }
                IntFile.ListValue mutator = section.asList("Mutator");
                return mutator.values().stream();
            }).filter(Objects::nonNull).filter(v -> v instanceof IntFile.MapValue && ((IntFile.MapValue)v).value().containsKey("FallbackName")).map(v -> (IntFile.MapValue)v).map(mapVal -> new NameDescription(mapVal.get("FallbackName"), mapVal.getOrDefault("FallbackDesc", ""))).sorted(Comparator.comparing(a -> a.name)).toList();
        }
        if (!intFiles.isEmpty()) {
            return IndexUtils.readIntFiles(incoming, intFiles).filter(Objects::nonNull).flatMap(intFile -> {
                IntFile.Section section = intFile.section("public");
                if (section == null) {
                    return null;
                }
                IntFile.ListValue prefs = section.asList("Object");
                return prefs.values().stream();
            }).filter(Objects::nonNull).filter(v -> v instanceof IntFile.MapValue && ((IntFile.MapValue)v).value().containsKey("MetaClass")).map(v -> (IntFile.MapValue)v).filter(mapVal -> "Engine.Mutator".equalsIgnoreCase(mapVal.get("MetaClass"))).map(mapVal -> new NameDescription(mapVal.get("Description"))).sorted(Comparator.comparing(a -> a.name)).toList();
        }
        if (!iniFiles.isEmpty()) {
            return IndexUtils.readIntFiles(incoming, iniFiles).filter(Objects::nonNull).flatMap(iniFile -> iniFile.sections().stream().map(name -> {
                IntFile.Section section = iniFile.section(name);
                if (section == null) {
                    return null;
                }
                if (name.toLowerCase().endsWith("UTUIDataProvider_Mutator".toLowerCase())) {
                    return MutatorIndexHandler.sectionToNameDesc(section, "Unknown Mutator");
                }
                return null;
            })).filter(Objects::nonNull).sorted(Comparator.comparing(a -> a.name)).toList();
        }
        return List.of();
    }

    private List<GameType.GameTypeMap> findMaps(Incoming incoming, GameType gameType, DataStore imageStore) {
        class FileAndPackage {
            final Incoming.IncomingFile f;
            final Package p;

            public FileAndPackage(GameTypeManager this$0, Incoming.IncomingFile f, Package p) {
                this.f = f;
                this.p = p;
            }
        }
        Set<Incoming.IncomingFile> mapFiles = incoming.files(FileType.MAP);
        return mapFiles.stream().map(mf -> new FileAndPackage(this, (Incoming.IncomingFile)mf, new Package(new PackageReader(mf.asChannel())))).map(fp -> {
            String mapName = Util.plainName((String)fp.f.file);
            String title = "";
            String author = "";
            Addon.Attachment[] attachment = new Addon.Attachment[]{null};
            Collection maybeLevelInfo = fp.p.objectsByClassName("LevelInfo");
            if (maybeLevelInfo != null && !maybeLevelInfo.isEmpty()) {
                Object level = maybeLevelInfo.stream().map(ExportedObject::object).filter(l -> l.property("Title") != null || l.property("Author") != null).findFirst().orElse(((ExportedObject)maybeLevelInfo.iterator().next()).object());
                Property authorProp = level.property("Author");
                Property titleProp = level.property("Title");
                Property screenshot = level.property("Screenshot");
                if (authorProp != null) {
                    author = ((StringProperty)authorProp).value.trim();
                }
                if (titleProp != null) {
                    title = ((StringProperty)titleProp).value.trim();
                }
                try {
                    List<BufferedImage> screenshots = IndexUtils.screenshots(incoming, fp.p, screenshot);
                    if (!screenshots.isEmpty()) {
                        System.out.printf("Storing screenshot for map %s%n", fp.f.fileName());
                        Path imgPath = Files.createTempFile(Util.slug((String)mapName), ".png", new FileAttribute[0]);
                        ImageIO.write((RenderedImage)screenshots.get(0), "png", imgPath.toFile());
                        Path emptyPath = Paths.get("", new String[0]);
                        imageStore.store(imgPath, emptyPath.relativize(gameType.contentPath(emptyPath)).resolve("maps").resolve(imgPath.getFileName().toString()).toString(), (url, ex) -> {
                            if (ex == null && url != null) {
                                attachment[0] = new Addon.Attachment(Addon.AttachmentType.IMAGE, imgPath.getFileName().toString(), url);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    System.err.printf("Failed to save screenshot for map %s%n", mapName);
                    e.printStackTrace();
                }
            }
            if (author.isBlank()) {
                author = "Unknown";
            }
            if (title.isBlank()) {
                title = mapName;
            }
            return new GameType.GameTypeMap(mapName, title, author, attachment[0]);
        }).sorted(Comparator.comparing(a -> a.name)).toList();
    }

    private String remotePath(GameType gametype) {
        return String.join((CharSequence)"/", REMOTE_ROOT, gametype.game, Util.slug((String)gametype.name));
    }
}

