/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.indexing;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.shrimpworks.unreal.packages.Umod;
import org.unrealarchive.common.ArchiveUtil;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.FileType;
import org.unrealarchive.indexing.IndexLog;
import org.unrealarchive.indexing.Submission;

public class Incoming
implements Closeable {
    private static final Duration EXTRACT_TIMEOUT = Duration.ofMinutes(2L);
    public final Submission submission;
    public final String hash;
    public final int fileSize;
    public final IndexLog log;
    private final Set<Umod> umods;
    public Path contentRoot;
    public Map<String, Object> files;
    private Path repackPath;

    public Incoming(Submission submission) throws IOException, UnsupportedOperationException {
        this(submission, IndexLog.NOP);
    }

    public Incoming(Submission submission, IndexLog log) throws IOException, UnsupportedOperationException {
        this.submission = submission;
        this.hash = Util.hash((Path)submission.filePath);
        this.fileSize = (int)Files.size(submission.filePath);
        this.umods = new HashSet<Umod>();
        this.log = log;
    }

    public Incoming prepare() throws IOException {
        this.contentRoot = Files.createTempDirectory("archive-incoming-", new FileAttribute[0]);
        this.unpackFiles(this.submission.filePath, this.contentRoot);
        this.files = this.listFiles(this.contentRoot);
        return this;
    }

    @Override
    public void close() {
        for (Umod v : this.umods) {
            try {
                v.close();
            }
            catch (Exception e) {
                this.log.log(IndexLog.EntryType.INFO, "Failed cleaning up Umod file " + String.valueOf(v), e);
            }
        }
        this.umods.clear();
        if (this.files != null) {
            this.files.clear();
        }
        if (this.contentRoot != null) {
            try {
                ArchiveUtil.cleanPath((Path)this.contentRoot);
            }
            catch (Exception e) {
                this.log.log(IndexLog.EntryType.INFO, "Failed cleaning up content path " + String.valueOf(this.contentRoot), e);
            }
        }
        if (this.repackPath != null) {
            try {
                ArchiveUtil.cleanPath((Path)this.repackPath);
            }
            catch (Exception e) {
                this.log.log(IndexLog.EntryType.INFO, "Failed cleaning up repack path " + String.valueOf(this.repackPath), e);
            }
        }
    }

    public Path getRepack(String repackName) throws IOException, InterruptedException {
        if (Util.extension((Path)this.submission.filePath).equalsIgnoreCase("zip")) {
            return null;
        }
        this.repackPath = Files.createTempDirectory("archive-repack-", new FileAttribute[0]);
        Path dest = this.repackPath.resolve(repackName + ".zip");
        if (this.contentRoot != null) {
            return ArchiveUtil.createZip((Path)this.contentRoot, (Path)dest, (Duration)Duration.ofSeconds(60L));
        }
        return null;
    }

    public Set<IncomingFile> files(FileType ... type) {
        HashSet res = new HashSet();
        for (FileType t : type) {
            res.addAll(this.files.keySet().stream().filter(arg_0 -> ((FileType)t).matches(arg_0)).map(x$0 -> new IncomingFile((String)x$0)).collect(Collectors.toSet()));
        }
        return Collections.unmodifiableSet(res);
    }

    private Map<String, Object> listFiles(Path contentRoot) throws IOException {
        final HashMap<String, Object> files = new HashMap<String, Object>();
        if (contentRoot != null && Files.exists(contentRoot, new LinkOption[0])) {
            Files.walkFileTree(contentRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toString().toLowerCase().endsWith(".umod") || file.toString().toLowerCase().endsWith(".ut2mod") || file.toString().toLowerCase().endsWith(".ut4mod")) {
                        files.putAll(Incoming.this.umodFiles(file));
                    }
                    files.put(file.toString(), file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return files;
    }

    private Map<String, Umod.UmodFile> umodFiles(Path path) throws IOException {
        HashMap<String, Umod.UmodFile> fileList = new HashMap<String, Umod.UmodFile>();
        Umod umod = new Umod(path);
        this.umods.add(umod);
        for (Umod.UmodFile file : umod.files) {
            if (file.name.equalsIgnoreCase("System\\Manifest.int") || file.name.equalsIgnoreCase("System\\Manifest.ini")) continue;
            fileList.put(file.name.replaceAll("\\\\", "/"), file);
        }
        return fileList;
    }

    private void unpackFiles(Path incoming, Path destination) throws IOException, UnsupportedOperationException {
        if (ArchiveUtil.isArchive((Path)incoming)) {
            this.extract(incoming, destination);
        } else if (FileType.important((Path)incoming)) {
            Files.copy(incoming, destination.resolve(incoming.getFileName()), StandardCopyOption.REPLACE_EXISTING);
        } else {
            throw new UnsupportedFileTypeException("Can't unpack file " + String.valueOf(incoming));
        }
    }

    private void extract(Path archive, Path destination) throws IOException, UnsupportedOperationException {
        try {
            ArchiveUtil.extract((Path)archive, (Path)destination, (Duration)EXTRACT_TIMEOUT, (boolean)true);
        }
        catch (InterruptedException e) {
            throw new IOException("Extract took too long", e);
        }
    }

    public String toString() {
        return String.format("Incoming [submission=%s, contentRoot=%s, hash=%s]", this.submission, this.contentRoot, this.hash);
    }

    public static class UnsupportedFileTypeException
    extends UnsupportedOperationException {
        public UnsupportedFileTypeException(String message) {
            super(message);
        }
    }

    public class IncomingFile {
        public final String file;

        private IncomingFile(String file) {
            this.file = file;
        }

        public SeekableByteChannel asChannel() {
            try {
                if (Incoming.this.files.get(this.file) instanceof Path) {
                    return FileChannel.open((Path)Incoming.this.files.get(this.file), new OpenOption[0]);
                }
                if (Incoming.this.files.get(this.file) instanceof Umod.UmodFile) {
                    return ((Umod.UmodFile)Incoming.this.files.get(this.file)).read();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to open file for reading " + this.file, e);
            }
            return null;
        }

        public String fileName() {
            return Util.fileName((String)this.file);
        }

        public int fileSize() {
            try {
                if (Incoming.this.files.get(this.file) instanceof Path) {
                    return (int)Files.size((Path)Incoming.this.files.get(this.file));
                }
                if (Incoming.this.files.get(this.file) instanceof Umod.UmodFile) {
                    return ((Umod.UmodFile)Incoming.this.files.get((Object)this.file)).size;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to get file size for " + this.file, e);
            }
            return 0;
        }

        public LocalDateTime fileDate() {
            try {
                Set<IncomingFile> umodMaybe;
                if (Incoming.this.files.get(this.file) instanceof Path) {
                    return Files.getLastModifiedTime((Path)Incoming.this.files.get(this.file), new LinkOption[0]).toInstant().atOffset(ZoneOffset.UTC).toLocalDateTime();
                }
                if (Incoming.this.files.get(this.file) instanceof Umod.UmodFile && !(umodMaybe = Incoming.this.files(FileType.UMOD)).isEmpty()) {
                    return umodMaybe.iterator().next().fileDate();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to get file date for " + this.file, e);
            }
            return LocalDateTime.now();
        }

        public FileType fileType() {
            return FileType.forFile((String)this.file);
        }

        public String hash() {
            try {
                if (Incoming.this.files.get(this.file) instanceof Path) {
                    return Util.hash((Path)((Path)Incoming.this.files.get(this.file)));
                }
                if (Incoming.this.files.get(this.file) instanceof Umod.UmodFile) {
                    return ((Umod.UmodFile)Incoming.this.files.get(this.file)).sha1();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to get hash for " + this.file, e);
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IncomingFile that = (IncomingFile)o;
            return Objects.equals(this.file, that.file);
        }

        public int hashCode() {
            return Objects.hash(this.file);
        }

        public String toString() {
            return String.format("IncomingFile [file=%s]", this.file);
        }
    }
}

