/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.indexing.mappacks;

import java.util.Objects;
import java.util.Set;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.FileType;
import org.unrealarchive.indexing.Classifier;
import org.unrealarchive.indexing.Incoming;
import org.unrealarchive.indexing.IndexLog;
import org.unrealarchive.indexing.IndexUtils;

public class MapPackClassifier
implements Classifier {
    @Override
    public boolean classify(Incoming incoming) {
        Set<Incoming.IncomingFile> maps = incoming.files(FileType.MAP);
        if (maps.size() <= 1) {
            return false;
        }
        for (Incoming.IncomingFile map : maps) {
            if (!Util.extension((String)map.fileName()).equalsIgnoreCase("ut3")) continue;
            return this.isUt3MapPack(incoming, maps);
        }
        Set<Incoming.IncomingFile> disallowed = incoming.files(FileType.INT, FileType.INI, FileType.PLAYER, FileType.UCL);
        return disallowed.isEmpty();
    }

    private boolean isUt3MapPack(Incoming incoming, Set<Incoming.IncomingFile> maps) {
        Set<Incoming.IncomingFile> inis = incoming.files(FileType.INI);
        long notMaps = IndexUtils.readIntFiles(incoming, inis, true).filter(Objects::nonNull).filter(iniFile -> {
            boolean maybeMutator = iniFile.sections().stream().anyMatch(s -> s.toLowerCase().contains("mutator"));
            boolean maybeChar = iniFile.sections().stream().anyMatch(s -> s.toLowerCase().contains("customchar"));
            boolean maybeWeapon = iniFile.sections().stream().anyMatch(s -> s.toLowerCase().contains("weapon"));
            boolean maybeGame = iniFile.sections().stream().anyMatch(s -> s.toLowerCase().contains("gamemode"));
            return maybeChar || maybeMutator || maybeWeapon || maybeGame;
        }).count();
        if (notMaps > 0L) {
            incoming.log.log(IndexLog.EntryType.INFO, "Not a UT3 map, contains characters, weapons, gametypes, etc.");
        }
        return notMaps == 0L;
    }
}

