/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.indexing.mappacks;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.shrimpworks.unreal.packages.IntFile;
import net.shrimpworks.unreal.packages.Package;
import net.shrimpworks.unreal.packages.PackageReader;
import net.shrimpworks.unreal.packages.entities.ExportedObject;
import net.shrimpworks.unreal.packages.entities.objects.Object;
import net.shrimpworks.unreal.packages.entities.properties.Property;
import net.shrimpworks.unreal.packages.entities.properties.StringProperty;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.Author;
import org.unrealarchive.content.Authors;
import org.unrealarchive.content.FileType;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.MapGameTypes;
import org.unrealarchive.content.addons.MapPack;
import org.unrealarchive.indexing.Incoming;
import org.unrealarchive.indexing.IndexHandler;
import org.unrealarchive.indexing.IndexLog;
import org.unrealarchive.indexing.IndexResult;
import org.unrealarchive.indexing.IndexUtils;
import org.unrealarchive.indexing.maps.MapIndexHandler;

public class MapPackIndexHandler
implements IndexHandler<MapPack> {
    @Override
    public void index(Incoming incoming, Addon content, Consumer<IndexResult<MapPack>> completed) {
        IndexLog log = incoming.log;
        MapPack m = (MapPack)content;
        Set<Incoming.IncomingFile> maps = incoming.files(FileType.MAP);
        if (maps.isEmpty()) {
            log.log(IndexLog.EntryType.FATAL, "Cannot index a map pack with no maps!", new IllegalStateException());
            return;
        }
        m.name = IndexUtils.friendlyName(m.name);
        boolean gameOverride = false;
        if (incoming.submission.override.get("game", null) != null) {
            gameOverride = true;
            m.game = incoming.submission.override.get("game", "Unreal Tournament");
        } else {
            m.game = IndexUtils.game((Incoming)incoming).name;
        }
        try (Package map = this.map(maps.iterator().next());){
            if (!gameOverride) {
                if (map.version < 69 || m.releaseDate != null && m.releaseDate.compareTo("1999-11") < 0) {
                    m.game = "Unreal";
                }
                if (map.version == 68 && map.objectsByClassName("LevelSummary").isEmpty()) {
                    m.game = "Unreal";
                }
            }
        }
        catch (IOException e2) {
            log.log(IndexLog.EntryType.CONTINUE, "Failed to read map package", e2);
        }
        catch (Exception e3) {
            log.log(IndexLog.EntryType.CONTINUE, "Caught while parsing map pack: " + e3.getMessage(), e3);
        }
        m.maps.clear();
        HashSet<IndexResult.NewAttachment> attachments = new HashSet<IndexResult.NewAttachment>();
        HashMap<String, Double> mapThemes = new HashMap<String, Double>();
        for (Incoming.IncomingFile map : maps) {
            try {
                m.maps.add(this.addMap(incoming, map, mapThemes, images -> {
                    try {
                        IndexUtils.saveImages("%s_shot_%s_%d.png", (Addon)m, images, attachments);
                    }
                    catch (IOException e) {
                        log.log(IndexLog.EntryType.CONTINUE, "Failed saving images for map pack map", e);
                    }
                }));
            }
            catch (Exception e4) {
                log.log(IndexLog.EntryType.CONTINUE, "Reading map failed", e4);
            }
        }
        try {
            IndexUtils.saveImages("%s_shot_%s_%d.png", (Addon)m, IndexUtils.findImageFiles(incoming), attachments);
        }
        catch (Exception e5) {
            log.log(IndexLog.EntryType.CONTINUE, "Failed finding additional attachment images", e5);
        }
        m.maps = m.maps.stream().distinct().toList();
        m.author = "Unknown";
        for (Incoming.IncomingFile map : m.maps) {
            Author mapAuthor;
            if (m.author.equals("Unknown")) {
                Author author = Authors.byName((String)((MapPack.PackMap)map).author);
                m.author = author != null ? author.name : "Unknown";
                continue;
            }
            Author packAuthor = Authors.byName((String)m.author);
            if (packAuthor == (mapAuthor = Authors.byName((String)((MapPack.PackMap)map).author))) continue;
            m.author = "Various";
            break;
        }
        m.gametype = "Unknown";
        for (Incoming.IncomingFile map : m.maps) {
            MapGameTypes.MapGameType gt = MapGameTypes.forMap((Games)Games.byName((String)m.game), (String)((MapPack.PackMap)map).name);
            if (gt == null) continue;
            if (m.gametype.equals("Unknown")) {
                m.gametype = gt.name();
                continue;
            }
            if (m.gametype.equalsIgnoreCase(gt.name())) continue;
            m.gametype = "Mixed";
            break;
        }
        Map<String, Double> topThemes = mapThemes.entrySet().stream().sorted((a, b) -> -((Double)a.getValue()).compareTo((Double)b.getValue())).limit(5L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        double totalScore = topThemes.values().stream().mapToDouble(e -> e).sum();
        m.themes.clear();
        m.themes.putAll(mapThemes.entrySet().stream().filter(e -> (Double)e.getValue() / totalScore > 0.05).collect(Collectors.toMap(Map.Entry::getKey, v -> BigDecimal.valueOf((Double)v.getValue() / totalScore).setScale(1, RoundingMode.HALF_UP).doubleValue())));
        completed.accept(new IndexResult<MapPack>(m, attachments));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MapPack.PackMap addMap(Incoming incoming, Incoming.IncomingFile map, Map<String, Double> themes, Consumer<List<BufferedImage>> listConsumer) {
        MapPack.PackMap p = new MapPack.PackMap();
        p.author = "Unknown";
        p.title = p.name = Util.plainName((String)map.fileName());
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        try (Package pkg = this.map(map);){
            if (Util.extension((String)map.fileName()).equalsIgnoreCase("ut3")) {
                MapPack.PackMap packMap = this.scrapeUE3(incoming, map, pkg, p, listConsumer);
                return packMap;
            }
            Collection maybeLevelInfo = pkg.objectsByClassName("LevelInfo");
            if (maybeLevelInfo != null && !maybeLevelInfo.isEmpty()) {
                ExportedObject levelInfo = (ExportedObject)maybeLevelInfo.iterator().next();
                if (levelInfo == null) {
                    MapPack.PackMap packMap = p;
                    return packMap;
                }
                Object level = levelInfo.object();
                Property author = level.property("Author");
                Property title = level.property("Title");
                if (author != null) {
                    p.author = ((StringProperty)author).value.trim();
                }
                if (title != null) {
                    p.title = ((StringProperty)title).value.trim();
                }
                Property screenshot = level.property("Screenshot");
                images.addAll(IndexUtils.screenshots(incoming, pkg, screenshot));
            }
            MapIndexHandler.themes(pkg).forEach((theme, weight) -> themes.compute((String)theme, (k, v) -> v == null ? weight : v + weight));
        }
        catch (Throwable e) {
            incoming.log.log(IndexLog.EntryType.CONTINUE, "Failed to read map properties", e);
        }
        listConsumer.accept(images);
        return p;
    }

    private MapPack.PackMap scrapeUE3(Incoming incoming, Incoming.IncomingFile map, Package pkg, MapPack.PackMap p, Consumer<List<BufferedImage>> listConsumer) {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        Set<Incoming.IncomingFile> iniFile = incoming.files(FileType.INI).stream().filter(f -> f.fileName().equalsIgnoreCase(Util.plainName((String)map.fileName()) + ".ini")).collect(Collectors.toSet());
        IndexUtils.readIntFiles(incoming, iniFile).findFirst().ifPresent(ini -> ini.sections().forEach(s -> {
            String playerCount;
            IntFile.Value players;
            IntFile.Value title;
            IntFile.Value name = ini.section(s).value("MapName");
            if (name instanceof IntFile.SimpleValue) {
                p.name = ((IntFile.SimpleValue)name).value().trim();
            }
            if ((title = ini.section(s).value("FriendlyName")) instanceof IntFile.SimpleValue) {
                p.title = ((IntFile.SimpleValue)title).value().trim();
            }
            if ((players = ini.section(s).value("NumPlayers")) instanceof IntFile.SimpleValue && (playerCount = ((IntFile.SimpleValue)players).value().replaceAll("([Pp]layers)", "")).toLowerCase().contains("author")) {
                p.author = playerCount.replaceAll(".*(?i)authors?\\s?:?\\s?(.*)", "$1");
            }
        }));
        try {
            images.addAll(IndexUtils.screenshots(incoming, pkg, null));
        }
        catch (Throwable e) {
            incoming.log.log(IndexLog.EntryType.CONTINUE, "Failed to extract screenshots: " + String.valueOf(e), e);
        }
        listConsumer.accept(images);
        return p;
    }

    private Package map(Incoming.IncomingFile file) {
        return new Package(new PackageReader(file.asChannel()));
    }

    public static class MapPackIndexHandlerFactory
    implements IndexHandler.IndexHandlerFactory<MapPack> {
        @Override
        public IndexHandler<MapPack> get() {
            return new MapPackIndexHandler();
        }
    }
}

