/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.indexing.maps;

import java.util.Set;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.FileType;
import org.unrealarchive.indexing.Classifier;
import org.unrealarchive.indexing.Incoming;

public class MapClassifier
implements Classifier {
    private static final Set<String> IGNORED_FILES = Set.of("Screen.int", "CTFScreen.int", "XMaps.int");
    private static final Set<String> IGNORED_FILE_TYPES = Set.of("exe", "dll");

    @Override
    public boolean classify(Incoming incoming) {
        Set<Incoming.IncomingFile> maps = incoming.files(FileType.MAP);
        Set<Incoming.IncomingFile> ints = incoming.files(FileType.INT);
        if (maps.isEmpty()) {
            return false;
        }
        if (ints.stream().anyMatch(i -> !IGNORED_FILES.contains(i.fileName()))) {
            return false;
        }
        if (incoming.files(new FileType[0]).stream().anyMatch(i -> IGNORED_FILE_TYPES.contains(Util.extension((String)i.fileName())))) {
            return false;
        }
        if (maps.size() == 1) {
            return true;
        }
        String baseName = "";
        for (Incoming.IncomingFile map : maps) {
            String tmp = Util.plainName((String)map.fileName()).toUpperCase().replaceAll("[^A-Z0-9]", "");
            if (!baseName.isEmpty() && tmp.length() >= baseName.length()) continue;
            baseName = tmp;
        }
        int variations = 0;
        for (Incoming.IncomingFile map : maps) {
            String tmp = Util.plainName((String)map.fileName()).toUpperCase().replaceAll("[^A-Z0-9]", "");
            if (!tmp.startsWith(baseName)) continue;
            ++variations;
        }
        return variations == maps.size();
    }
}

