/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.indexing.maps;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.shrimpworks.unreal.packages.IntFile;
import net.shrimpworks.unreal.packages.Package;
import net.shrimpworks.unreal.packages.PackageReader;
import net.shrimpworks.unreal.packages.entities.ExportedObject;
import net.shrimpworks.unreal.packages.entities.Import;
import net.shrimpworks.unreal.packages.entities.Named;
import net.shrimpworks.unreal.packages.entities.objects.Object;
import net.shrimpworks.unreal.packages.entities.objects.Polys;
import net.shrimpworks.unreal.packages.entities.properties.ArrayProperty;
import net.shrimpworks.unreal.packages.entities.properties.IntegerProperty;
import net.shrimpworks.unreal.packages.entities.properties.Property;
import net.shrimpworks.unreal.packages.entities.properties.StringProperty;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.FileType;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.MapGameTypes;
import org.unrealarchive.content.addons.MapThemes;
import org.unrealarchive.indexing.Incoming;
import org.unrealarchive.indexing.IndexHandler;
import org.unrealarchive.indexing.IndexLog;
import org.unrealarchive.indexing.IndexResult;
import org.unrealarchive.indexing.IndexUtils;

public class MapIndexHandler
implements IndexHandler<org.unrealarchive.content.addons.Map> {
    private static final Pattern SP_MATCH = Pattern.compile("(.+)?(single ?player|cooperative)([\\s:]+)?yes(\\s+)?", 2);
    private static final int BOT_PATH_MIN = 5;

    @Override
    public void index(Incoming incoming, Addon content, Consumer<IndexResult<org.unrealarchive.content.addons.Map>> completed) {
        IndexLog log = incoming.log;
        org.unrealarchive.content.addons.Map m = (org.unrealarchive.content.addons.Map)content;
        Incoming.IncomingFile baseMap = this.baseMap(incoming);
        m.title = m.name = this.mapName(baseMap);
        boolean gameOverride = false;
        if (incoming.submission.override.get("game", null) != null) {
            gameOverride = true;
            m.game = incoming.submission.override.get("game", "Unreal Tournament");
        } else {
            m.game = IndexUtils.game((Incoming)incoming).name;
        }
        m.gametype = this.gameType(incoming, Games.byName((String)m.game), m.name);
        HashSet<IndexResult.NewAttachment> attachments = new HashSet<IndexResult.NewAttachment>();
        ArrayList<BufferedImage> screenshots = new ArrayList<BufferedImage>();
        try (Package map = this.map(baseMap);){
            if (map.version < 200) {
                this.scrapeUE12(incoming, m, gameOverride, map, screenshots);
            } else {
                this.scrapeUE3(incoming, m, map, screenshots);
            }
            m.themes.clear();
            m.themes.putAll(MapIndexHandler.themes(map));
            m.bots = MapIndexHandler.botSupport(map);
        }
        catch (IOException e) {
            log.log(IndexLog.EntryType.CONTINUE, "Failed to read map package", e);
        }
        catch (Exception e) {
            log.log(IndexLog.EntryType.CONTINUE, "Caught while parsing map: " + e.getMessage(), e);
        }
        try {
            screenshots.addAll(IndexUtils.findImageFiles(incoming));
            IndexUtils.saveImages("%s_shot_%s_%d.png", (Addon)m, screenshots, attachments);
        }
        catch (IOException e) {
            log.log(IndexLog.EntryType.CONTINUE, "Failed to store images", e);
        }
        try {
            if (m.author.isBlank() || m.author.equals("Unknown")) {
                m.author = IndexUtils.findAuthor(incoming);
            }
            if (m.playerCount.isBlank() || m.playerCount.equals("Unknown")) {
                m.playerCount = m.gametype.equals("1 on 1") ? "2" : (m.gametype.equals("Single Player") ? "1" : IndexUtils.findPlayerCount(incoming));
            }
            if (m.gametype.equalsIgnoreCase("DeathMatch") && m.name.startsWith("DM") && m.name.toLowerCase().contains("1on1")) {
                m.gametype = "1 on 1";
            }
        }
        catch (Exception e) {
            log.log(IndexLog.EntryType.CONTINUE, "Caught while updating map fallbacks: " + e.getMessage(), e);
        }
        completed.accept(new IndexResult<org.unrealarchive.content.addons.Map>(m, attachments));
    }

    private void scrapeUE12(Incoming incoming, org.unrealarchive.content.addons.Map m, boolean gameOverride, Package map, List<BufferedImage> screenshots) {
        Property description;
        Collection maybeLevelInfo;
        if (!gameOverride) {
            if (map.version < 68 || m.releaseDate != null && m.releaseDate.compareTo("1999-11") < 0) {
                m.game = "Unreal";
            }
            if (map.version == 68 && map.objectsByClassName("LevelSummary").isEmpty()) {
                m.game = "Unreal";
            }
        }
        if ((maybeLevelInfo = map.objectsByClassName("LevelInfo")) == null || maybeLevelInfo.isEmpty()) {
            throw new IllegalArgumentException("Could not find LevelInfo in map");
        }
        Object level = maybeLevelInfo.stream().map(ExportedObject::object).filter(l -> l.property("Title") != null || l.property("Author") != null).findFirst().orElse(((ExportedObject)maybeLevelInfo.iterator().next()).object());
        Property author = level.property("Author");
        Property title = level.property("Title");
        Property property = description = level.property("Description") != null ? level.property("Description") : level.property("LevelEnterText");
        if (author != null) {
            m.author = ((StringProperty)author).value.trim();
        }
        if (title != null) {
            m.title = ((StringProperty)title).value.trim();
        }
        if (description != null) {
            m.description = ((StringProperty)description).value.trim();
        }
        if (m.author.isBlank()) {
            m.author = "Unknown";
        }
        if (m.title.isBlank()) {
            m.title = m.name;
        }
        if (map.version < 117) {
            Property idealPlayerCount = level.property("IdealPlayerCount");
            if (idealPlayerCount != null) {
                m.playerCount = ((StringProperty)idealPlayerCount).value.trim();
            }
        } else {
            Property idealPlayerCountMin = level.property("IdealPlayerCountMin");
            Property idealPlayerCountMax = level.property("IdealPlayerCountMax");
            int min = 0;
            int max = 0;
            if (idealPlayerCountMin != null) {
                min = ((IntegerProperty)idealPlayerCountMin).value;
            }
            if (idealPlayerCountMax != null) {
                max = ((IntegerProperty)idealPlayerCountMax).value;
            }
            if (min == max && max > 0) {
                m.playerCount = Integer.toString(max);
            } else if (min > 0 && max > 0) {
                m.playerCount = min + "-" + max;
            } else if (min > 0 || max > 0) {
                m.playerCount = Integer.toString(Math.max(min, max));
            }
        }
        Property screenshot = level.property("Screenshot");
        if (!gameOverride) {
            if (screenshot != null && map.version < 117 && !map.objectsByClassName("LevelSummary").isEmpty() && m.game.equals("Unreal")) {
                m.game = "Unreal Tournament";
            } else if (m.gametype.equals("XMP") && map.version >= 126 && !map.exportsByClassName("DeploymentPoint").isEmpty() && m.game.equals("Unreal Tournament")) {
                m.game = "Unreal 2";
            }
        }
        try {
            screenshots.addAll(IndexUtils.screenshots(incoming, map, screenshot));
        }
        catch (Throwable e) {
            incoming.log.log(IndexLog.EntryType.CONTINUE, "Failed to extract screenshot: " + String.valueOf(e), e);
        }
    }

    private void scrapeUE3(Incoming incoming, org.unrealarchive.content.addons.Map m, Package map, List<BufferedImage> screenshots) {
        IndexUtils.readIntFiles(incoming, incoming.files(FileType.INI)).findFirst().ifPresent(ini -> ini.sections().forEach(s -> {
            IntFile.Value players;
            IntFile.Value desc;
            IntFile.Value title;
            IntFile.Value name = ini.section(s).value("MapName");
            if (name instanceof IntFile.SimpleValue) {
                m.name = ((IntFile.SimpleValue)name).value().trim();
            }
            if ((title = ini.section(s).value("FriendlyName")) instanceof IntFile.SimpleValue) {
                m.title = ((IntFile.SimpleValue)title).value().trim();
            }
            if ((desc = ini.section(s).value("Description")) instanceof IntFile.SimpleValue) {
                m.description = ((IntFile.SimpleValue)desc).value().trim();
            }
            if ((players = ini.section(s).value("NumPlayers")) instanceof IntFile.SimpleValue) {
                String playerCount = ((IntFile.SimpleValue)players).value().replaceAll("([Pp]layers)", "");
                if (playerCount.toLowerCase().contains("author")) {
                    m.playerCount = playerCount.substring(0, playerCount.toLowerCase().indexOf("author")).trim();
                    m.author = playerCount.replaceAll(".*(?i)authors?\\s?:?\\s?(.*)", "$1");
                } else {
                    m.playerCount = playerCount.toLowerCase(Locale.ROOT).trim();
                }
            }
        }));
        try {
            screenshots.addAll(IndexUtils.screenshots(incoming, map, null));
        }
        catch (Throwable e) {
            incoming.log.log(IndexLog.EntryType.CONTINUE, "Failed to extract screenshots: " + String.valueOf(e), e);
        }
    }

    private Incoming.IncomingFile baseMap(Incoming incoming) {
        Set<Incoming.IncomingFile> maps = incoming.files(FileType.MAP);
        Incoming.IncomingFile shortestMap = null;
        for (Incoming.IncomingFile map : maps) {
            if (shortestMap != null && map.fileName().length() >= shortestMap.fileName().length()) continue;
            shortestMap = map;
        }
        return shortestMap;
    }

    private Package map(Incoming.IncomingFile mapFile) {
        return new Package(new PackageReader(mapFile.asChannel(), false));
    }

    private String mapName(Incoming.IncomingFile mapFile) {
        return Util.plainName((String)mapFile.fileName());
    }

    private String gameType(Incoming incoming, Games game, String name) {
        if (incoming.submission.override.get("gameType", null) != null) {
            return incoming.submission.override.get("gameType", "DeathMatch");
        }
        MapGameTypes.MapGameType gameType = MapGameTypes.forMap((Games)game, (String)name);
        if (gameType == null && this.maybeSingleplayer(incoming)) {
            return "Single Player";
        }
        if (gameType != null) {
            return gameType.name();
        }
        return "Unknown";
    }

    private boolean maybeSingleplayer(Incoming incoming) {
        if (incoming.submission.filePath.toString().toLowerCase().contains("singleplayer") || incoming.submission.filePath.toString().toLowerCase().contains("coop")) {
            return true;
        }
        try {
            List<String> lines = IndexUtils.textContent(incoming, FileType.TEXT, FileType.HTML);
            for (String s : lines) {
                Matcher m = SP_MATCH.matcher(s);
                if (!m.matches()) continue;
                return true;
            }
        }
        catch (Exception e) {
            incoming.log.log(IndexLog.EntryType.CONTINUE, "Couldn't figure out if singleplayer by reading text files", e);
        }
        return false;
    }

    public static Map<String, Double> themes(Package pkg) {
        HashMap foundThemes = new HashMap();
        if (pkg.version > 199) {
            return Map.of();
        }
        pkg.objectsByClassName("Polys").forEach(o -> {
            Polys polys = (Polys)o.object();
            polys.polys.stream().map((? super T p) -> p.texture.get()).filter(n -> n instanceof Import).map((? super T n) -> (Import)n).forEach(i -> {
                Import current = i;
                Named parent = i.packageIndex.get();
                while (parent instanceof Import) {
                    current = (Import)parent;
                    parent = current.packageIndex.get();
                }
                String theme = MapThemes.findTheme((String)current.name.name);
                if (theme != null) {
                    foundThemes.compute(theme, (k, v) -> {
                        int n;
                        if (v == null) {
                            n = 1;
                        } else {
                            v = v + 1;
                            n = v;
                        }
                        return n;
                    });
                }
            });
        });
        Map<String, Integer> mapThemes = foundThemes.entrySet().stream().sorted((a, b) -> -((Integer)a.getValue()).compareTo((Integer)b.getValue())).limit(5L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        double totalScore = mapThemes.values().stream().mapToInt(e -> e).sum();
        return mapThemes.entrySet().stream().filter(e -> (double)((Integer)e.getValue()).intValue() / totalScore > 0.05).collect(Collectors.toMap(Map.Entry::getKey, v -> BigDecimal.valueOf((double)((Integer)v.getValue()).intValue() / totalScore).setScale(1, RoundingMode.HALF_UP).doubleValue()));
    }

    public static boolean botSupport(Package pkg) {
        return pkg.version < 117 ? Stream.concat(pkg.objectsByClassName("PathNode").stream(), pkg.objectsByClassName("InventorySpot").stream()).filter(n -> pkg.object(n).property("Paths") instanceof ArrayProperty && !((ArrayProperty)pkg.object((ExportedObject)n).property((String)"Paths")).values.isEmpty()).count() > 5L : pkg.objectsByClassName("ReachSpec").size() > 5;
    }

    public static class MapIndexHandlerFactory
    implements IndexHandler.IndexHandlerFactory<org.unrealarchive.content.addons.Map> {
        @Override
        public IndexHandler<org.unrealarchive.content.addons.Map> get() {
            return new MapIndexHandler();
        }
    }
}

