/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.indexing.mutators;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.shrimpworks.unreal.packages.IntFile;
import org.unrealarchive.content.FileType;
import org.unrealarchive.indexing.Classifier;
import org.unrealarchive.indexing.Incoming;
import org.unrealarchive.indexing.IndexUtils;

public class MutatorClassifier
implements Classifier {
    private static final List<String> INVALID_CLASSES = List.of(".voice", "tournamentgameinfo", "tournamentplayer", "gameinfo");
    private static final List<String> INVALID_UT3_SECTIONS = List.of("UTUIDataProvider_GameModeInfo".toLowerCase());
    public static final String UT_MUTATOR_CLASS = "Engine.Mutator";
    static final String UT_MENU_CLASS = "UMenu.UMenuModMenuItem";
    static final String UT_KEYBINDINGS_CLASS = "UTMenu.UTExtraKeyBindings";
    static final String UT_WEAPON_CLASS = "Botpack.TournamentWeapon";
    static final String UT2_KEYBINDINGS_CLASS = "Xinterface.GUIUserKeyBinding";
    public static final String UT3_MUTATOR_SECTION = "UTUIDataProvider_Mutator";
    static final String UT3_WEAPON_SECTION = "UTUIDataProvider_Weapon";
    static final String UT3_VEHICLE_SECTION = "UTUIDataProvider_Vehicle";

    @Override
    public boolean classify(Incoming incoming) {
        Set<Incoming.IncomingFile> intFiles = incoming.files(FileType.INT);
        Set<Incoming.IncomingFile> iniFiles = incoming.files(FileType.INI);
        Set<Incoming.IncomingFile> uclFiles = incoming.files(FileType.UCL);
        Set<Incoming.IncomingFile> codeFiles = incoming.files(FileType.CODE);
        Set<Incoming.IncomingFile> miscFiles = incoming.files(FileType.MAP, FileType.PLAYER);
        if (!miscFiles.isEmpty()) {
            return false;
        }
        if ((intFiles.isEmpty() || uclFiles.isEmpty() || iniFiles.isEmpty()) && codeFiles.isEmpty()) {
            return false;
        }
        boolean utMutator = !intFiles.isEmpty() && this.checkUTMutator(incoming, intFiles);
        boolean ut2004Mutator = !uclFiles.isEmpty() && !utMutator && this.checkUT2004Mutator(incoming, uclFiles);
        boolean ut3Mutator = !iniFiles.isEmpty() && !utMutator && !ut2004Mutator && this.checkUT3Mutator(incoming, iniFiles);
        return utMutator || ut2004Mutator || ut3Mutator;
    }

    private boolean checkUTMutator(Incoming incoming, Set<Incoming.IncomingFile> intFiles) {
        AtomicBoolean seemsToBeAMutator = new AtomicBoolean(false);
        AtomicBoolean probablyNotAMutator = new AtomicBoolean(false);
        IndexUtils.readIntFiles(incoming, intFiles).filter(Objects::nonNull).forEach(intFile -> {
            if (probablyNotAMutator.get()) {
                return;
            }
            IntFile.Section section = intFile.section("public");
            if (section == null) {
                return;
            }
            IntFile.ListValue objects = section.asList("Object");
            for (IntFile.Value value : objects.values()) {
                IntFile.MapValue mapVal;
                if (!(value instanceof IntFile.MapValue) || !(mapVal = (IntFile.MapValue)value).containsKey("MetaClass")) continue;
                if (INVALID_CLASSES.stream().anyMatch(s -> mapVal.get("MetaClass").toLowerCase().contains((CharSequence)s))) {
                    probablyNotAMutator.set(true);
                    return;
                }
                if (!UT_MUTATOR_CLASS.equalsIgnoreCase(mapVal.get("MetaClass"))) continue;
                seemsToBeAMutator.set(true);
            }
        });
        return !probablyNotAMutator.get() && seemsToBeAMutator.get();
    }

    private boolean checkUT2004Mutator(Incoming incoming, Set<Incoming.IncomingFile> uclFiles) {
        AtomicBoolean seemsToBeAMutator = new AtomicBoolean(false);
        AtomicBoolean probablyNotAMutator = new AtomicBoolean(false);
        IndexUtils.readIntFiles(incoming, uclFiles, true).filter(Objects::nonNull).forEach(uclFile -> {
            if (probablyNotAMutator.get()) {
                return;
            }
            IntFile.Section section = uclFile.section("root");
            if (section == null) {
                return;
            }
            if (section.keys().contains("Map") || section.keys().contains("Game")) {
                probablyNotAMutator.set(true);
                return;
            }
            if (section.keys().contains("Mutator")) {
                seemsToBeAMutator.set(true);
            }
        });
        return !probablyNotAMutator.get() && seemsToBeAMutator.get();
    }

    private boolean checkUT3Mutator(Incoming incoming, Set<Incoming.IncomingFile> iniFiles) {
        return IndexUtils.readIntFiles(incoming, iniFiles).filter(Objects::nonNull).anyMatch(iniFile -> iniFile.sections().stream().noneMatch(s -> INVALID_UT3_SECTIONS.stream().anyMatch(n -> s.toLowerCase().trim().endsWith(n.toLowerCase()))) && iniFile.sections().stream().anyMatch(s -> s.toLowerCase().trim().endsWith(UT3_MUTATOR_SECTION.toLowerCase())));
    }
}

