/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.indexing.voices;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import net.shrimpworks.unreal.packages.IntFile;
import org.unrealarchive.content.FileType;
import org.unrealarchive.indexing.Classifier;
import org.unrealarchive.indexing.Incoming;
import org.unrealarchive.indexing.IndexUtils;

public class VoiceClassifier
implements Classifier {
    private static final List<String> INVALID_CLASSES = List.of("engine.mutator", "botpack.tournamentweapon", "botpack.tournamentgameinfo", "botpack.tournamentplayer");
    static final Pattern UT_VOICE_MATCH = Pattern.compile("Botpack\\.Voice.+?", 2);
    static final String UT2_VOICE_CLASS = "XGame.xVoicePack";

    @Override
    public boolean classify(Incoming incoming) {
        Set<Incoming.IncomingFile> intFiles = incoming.files(FileType.INT);
        Set<Incoming.IncomingFile> codeFiles = incoming.files(FileType.CODE);
        Set<Incoming.IncomingFile> soundFiles = incoming.files(FileType.SOUNDS);
        Set<Incoming.IncomingFile> miscFiles = incoming.files(FileType.MAP, FileType.MUSIC, FileType.STATICMESH, FileType.ANIMATION, FileType.PLAYER);
        if (!miscFiles.isEmpty()) {
            return false;
        }
        if (intFiles.isEmpty() || codeFiles.isEmpty() && soundFiles.isEmpty()) {
            return false;
        }
        return this.checkVoice(incoming, intFiles);
    }

    private boolean checkVoice(Incoming incoming, Set<Incoming.IncomingFile> intFiles) {
        AtomicBoolean seemsToBeAVoice = new AtomicBoolean(false);
        AtomicBoolean probablyNotAVoice = new AtomicBoolean(false);
        IndexUtils.readIntFiles(incoming, intFiles).filter(Objects::nonNull).forEach(intFile -> {
            if (probablyNotAVoice.get()) {
                return;
            }
            IntFile.Section section = intFile.section("public");
            if (section == null) {
                return;
            }
            IntFile.ListValue objects = section.asList("Object");
            for (IntFile.Value value : objects.values()) {
                IntFile.MapValue mapVal;
                if (!(value instanceof IntFile.MapValue) || !(mapVal = (IntFile.MapValue)value).containsKey("MetaClass")) continue;
                if (INVALID_CLASSES.contains(mapVal.get("MetaClass").toLowerCase())) {
                    probablyNotAVoice.set(true);
                    return;
                }
                if (mapVal.get("MetaClass").equalsIgnoreCase(UT2_VOICE_CLASS)) {
                    seemsToBeAVoice.set(true);
                    return;
                }
                if (!UT_VOICE_MATCH.matcher(mapVal.get("MetaClass")).matches()) continue;
                seemsToBeAVoice.set(true);
            }
        });
        return !probablyNotAVoice.get() && seemsToBeAVoice.get();
    }
}

