/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.mirror;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.ContentEntity;
import org.unrealarchive.content.Download;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.GameType;
import org.unrealarchive.content.addons.GameTypeRepository;
import org.unrealarchive.content.addons.SimpleAddonRepository;
import org.unrealarchive.content.managed.Managed;
import org.unrealarchive.content.managed.ManagedContentRepository;
import org.unrealarchive.indexing.ContentManager;
import org.unrealarchive.indexing.GameTypeManager;
import org.unrealarchive.indexing.IndexResult;
import org.unrealarchive.indexing.ManagedContentManager;
import org.unrealarchive.mirror.Progress;
import org.unrealarchive.storage.DataStore;

public class Mirror
implements Consumer<Transfer> {
    private static final int RETRY_LIMIT = 4;
    private final ContentManager cm;
    private final GameTypeManager gm;
    private final ManagedContentManager mm;
    private final DataStore mirrorStore;
    private Deque<ContentEntity<?>> content;
    private Deque<ContentEntity<?>> retryQueue;
    private final int concurrency;
    private final ExecutorService executor;
    private final Progress progress;
    private final long totalCount;
    private volatile CountDownLatch counter;
    private volatile Thread mirrorThread;

    public Mirror(SimpleAddonRepository repo, ContentManager cm, GameTypeRepository gametypes, GameTypeManager gm, ManagedContentRepository managed, ManagedContentManager mm, DataStore mirrorStore, int concurrency, LocalDate since, LocalDate until, Progress progress) {
        this.cm = cm;
        this.gm = gm;
        this.mm = mm;
        this.mirrorStore = mirrorStore;
        LocalDate sinceFilter = since.minusDays(1L);
        LocalDate untilFilter = until.plusDays(1L);
        this.content = Stream.concat(repo.all().stream(), Stream.concat(gametypes.all().stream(), managed.all().stream())).filter(c -> c.addedDate().toLocalDate().isAfter(sinceFilter)).filter(c -> c.addedDate().toLocalDate().isBefore(untilFilter)).collect(Collectors.toCollection(ConcurrentLinkedDeque::new));
        this.retryQueue = new ConcurrentLinkedDeque();
        this.concurrency = concurrency;
        this.progress = progress;
        this.totalCount = this.content.size();
        this.executor = Executors.newFixedThreadPool(concurrency);
    }

    public void cancel() {
        this.executor.shutdownNow();
        if (this.mirrorThread != null) {
            this.mirrorThread.interrupt();
            this.mirrorThread = null;
        }
    }

    public void mirror() {
        this.mirrorThread = Thread.currentThread();
        try {
            for (int retryCount = 0; retryCount <= 4 && !this.content.isEmpty(); ++retryCount) {
                if (retryCount > 0) {
                    System.err.printf("%n%d mirror operations failed, retrying (%d/%d)...%n", this.content.size(), retryCount, 4);
                }
                this.counter = new CountDownLatch(this.content.size());
                for (int i = 0; i < this.concurrency; ++i) {
                    this.next();
                }
                this.counter.await();
                if (this.retryQueue.isEmpty()) continue;
                this.content = this.retryQueue;
                this.retryQueue = new ConcurrentLinkedDeque();
            }
            if (!this.retryQueue.isEmpty()) {
                System.err.printf("%nA total of %d mirror operations failed, giving up after %d retries.%n", this.retryQueue.size(), 4);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.mirrorThread = null;
        }
    }

    @Override
    public void accept(Transfer transfer) {
        this.progress.progress(this.totalCount, this.content.size(), transfer.content);
        this.counter.countDown();
        this.next();
    }

    private void next() {
        ContentEntity<?> c = this.content.poll();
        if (c != null) {
            this.executor.submit(new Transfer(c, this.mirrorStore, this));
        }
    }

    public class Transfer
    implements Runnable {
        private final ContentEntity<?> content;
        private final DataStore mirrorStore;
        private final Consumer<Transfer> done;

        public Transfer(ContentEntity<?> c, DataStore mirrorStore, Consumer<Transfer> done) {
            this.content = c;
            this.mirrorStore = mirrorStore;
            this.done = done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                ContentEntity<?> contentEntity = this.content;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Addon.class, GameType.class, Managed.class}, contentEntity, n)) {
                    case 0: {
                        Addon addon = (Addon)contentEntity;
                        this.mirrorContent(addon);
                        return;
                    }
                    case 1: {
                        GameType gameType = (GameType)contentEntity;
                        this.mirrorGameType(gameType);
                        return;
                    }
                    case 2: {
                        Managed managed = (Managed)contentEntity;
                        this.mirrorManaged(managed);
                        return;
                    }
                    default: {
                        System.out.printf("%nContent mirroring not yet supported for type %s: %s%n", this.content.getClass().getSimpleName(), this.content.name());
                        return;
                    }
                }
            }
            catch (MirrorFailedException t) {
                System.err.printf("%nFailed to transfer content %s: %s (queued for retry)%n", t.filename, t);
                Mirror.this.retryQueue.add(t.content);
                return;
            }
            finally {
                this.done.accept(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mirrorManaged(Managed managed) throws MirrorFailedException {
            Managed clone = Mirror.this.mm.checkout(managed);
            for (Managed.ManagedFile managedFile : clone.downloads) {
                try {
                    Path localFile = Paths.get(managedFile.localFile, new String[0]);
                    boolean hasLocalFile = Files.exists(localFile, new LinkOption[0]);
                    if (!hasLocalFile) {
                        Download dl = managedFile.directDownload();
                        localFile = Util.downloadTo((String)dl.url.replaceAll(" ", "%20"), (Path)Files.createTempDirectory("ua-mirror", new FileAttribute[0]).resolve(Util.fileName((String)managedFile.localFile)));
                    }
                    try {
                        boolean[] success = new boolean[]{false};
                        Mirror.this.mm.storeDownloadFile(clone, managedFile, localFile, success);
                        if (success[0]) continue;
                        throw new MirrorFailedException("Mirror of managed file failed", null, managedFile.originalFilename, (ContentEntity<?>)clone);
                    }
                    finally {
                        if (hasLocalFile) continue;
                        Files.deleteIfExists(localFile);
                    }
                }
                catch (Exception ex) {
                    throw new MirrorFailedException(ex.getMessage(), (Throwable)ex, managedFile.originalFilename, (ContentEntity<?>)clone);
                }
            }
            Mirror.this.mm.checkin(clone);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mirrorGameType(GameType gameType) throws MirrorFailedException {
            GameType clone = Mirror.this.gm.checkout(gameType);
            for (GameType.Release release : clone.releases) {
                for (GameType.ReleaseFile releaseFile : release.files) {
                    try {
                        Path localFile = Paths.get(releaseFile.localFile, new String[0]);
                        boolean hasLocalFile = Files.exists(localFile, new LinkOption[0]);
                        if (!hasLocalFile) {
                            Download dl = releaseFile.directDownload();
                            localFile = Util.downloadTo((String)dl.url, (Path)Files.createTempDirectory("ua-mirror", new FileAttribute[0]).resolve(releaseFile.originalFilename));
                        }
                        try {
                            boolean[] success = new boolean[]{false};
                            Mirror.this.gm.syncReleaseFile(clone, releaseFile, localFile, success);
                            if (success[0]) continue;
                            throw new MirrorFailedException("Mirror of gametype failed", null, releaseFile.originalFilename, (ContentEntity<?>)clone);
                        }
                        finally {
                            if (hasLocalFile) continue;
                            Files.deleteIfExists(localFile);
                        }
                    }
                    catch (Exception ex) {
                        throw new MirrorFailedException(ex.getMessage(), (Throwable)ex, releaseFile.originalFilename, (ContentEntity<?>)clone);
                    }
                }
            }
            Mirror.this.gm.checkin(clone);
        }

        private void mirrorContent(Addon content) throws MirrorFailedException {
            try {
                Download dl = content.directDownload();
                if (dl == null) {
                    return;
                }
                Util.urlRequest((String)dl.url, httpConn -> {
                    try {
                        Path base = Paths.get("", new String[0]);
                        Path uploadPath = content.contentPath(base);
                        String uploadName = base.relativize(uploadPath.resolve(Util.fileName((String)content.originalFilename))).toString();
                        long length = httpConn.getContentLength() > -1 ? (long)httpConn.getContentLength() : (long)content.fileSize;
                        this.mirrorStore.store(httpConn.getInputStream(), length, uploadName, (newUrl, ex) -> {
                            if (ex != null) {
                                System.err.printf("%nFailed to transfer content %s: %s (queued for retry)%n", content.originalFilename, ex);
                                Mirror.this.retryQueue.add((ContentEntity<?>)content);
                            }
                            if (newUrl != null && content.downloads.stream().noneMatch(d -> d.url.equalsIgnoreCase((String)newUrl))) {
                                Addon updated = Mirror.this.cm.checkout(content.hash);
                                updated.downloads.add(new Download(newUrl, true, Download.DownloadState.OK));
                                try {
                                    Mirror.this.cm.checkin(new IndexResult<Addon>(updated, Collections.emptySet()), null);
                                }
                                catch (IOException e) {
                                    System.err.printf("%nFailed to record new download for %s: %s (queued for retry)%n", content.originalFilename, e);
                                    Mirror.this.retryQueue.add((ContentEntity<?>)content);
                                }
                            }
                        });
                    }
                    catch (IOException e) {
                        System.err.printf("%nFailed to transfer content %s: %s (queued for retry)%n", content.originalFilename, e);
                        Mirror.this.retryQueue.add((ContentEntity<?>)content);
                    }
                });
            }
            catch (Throwable t) {
                throw new MirrorFailedException(t.getMessage(), t, content.originalFilename, (ContentEntity<?>)content);
            }
        }
    }

    private static class MirrorFailedException
    extends Exception {
        public final String filename;
        public final ContentEntity<?> content;

        public MirrorFailedException(String message, Throwable cause, String filename, ContentEntity<?> content) {
            super(message, cause);
            this.filename = filename;
            this.content = content;
        }
    }
}

