/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.submitter;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unrealarchive.submitter.ClamScan;

public class ClamDScan
extends ClamScan {
    private static final Logger logger = LoggerFactory.getLogger(ClamDScan.class);
    private static final String CLAMSCAN_OPTIONS = "-avr";
    private static final String CLAMSCAN = "clamdscan";
    private static final String CLAMD = "/usr/sbin/clamd";
    private static final Duration SCAN_TIMEOUT = Duration.ofSeconds(300L);
    private final String clamCommand;
    private final ClamDConfig clamConfig;

    public ClamDScan(String clamCommand, ClamDConfig clamConfig) {
        this.clamCommand = clamCommand;
        this.clamConfig = clamConfig;
    }

    public ClamDScan(ClamDConfig clamConfig) {
        this(CLAMSCAN, clamConfig);
    }

    @Override
    protected String[] clamCommand(Path[] paths) {
        String[] cmd = new String[paths.length + 3];
        cmd[0] = this.clamCommand;
        cmd[1] = CLAMSCAN_OPTIONS;
        cmd[2] = String.format("--config-file=%s", this.clamConfig.clamdConf.toAbsolutePath());
        for (int i = 0; i < paths.length; ++i) {
            cmd[i + 3] = paths[0].toAbsolutePath().toString();
        }
        return cmd;
    }

    public static class ClamDConfig
    implements Closeable {
        public final Path socketPath;
        public final Path clamdConf;

        public ClamDConfig(Path socketPath) throws IOException {
            this.socketPath = socketPath;
            this.clamdConf = Files.createTempFile("clamd", ".conf", new FileAttribute[0]);
            Files.writeString(this.clamdConf, (CharSequence)String.format("LocalSocket %s", socketPath.toAbsolutePath()), new OpenOption[0]);
            logger.info("Created config file at {}", (Object)this.clamdConf);
        }

        @Override
        public void close() {
            try {
                Files.deleteIfExists(this.clamdConf);
            }
            catch (Exception ex) {
                logger.warn("Failed to remove clam config file {}}", (Object)this.clamdConf, (Object)ex);
            }
        }
    }

    public static class ClamD
    implements Closeable {
        private final String clamdCommand;
        private final ClamDConfig clamConfig;
        private final Process clamd;

        public ClamD(String clamdCommand, ClamDConfig clamConfig) {
            this.clamdCommand = clamdCommand;
            this.clamConfig = clamConfig;
            try {
                this.clamd = this.startClamd();
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Failed to start clamd with command %s", clamdCommand), e);
            }
        }

        public ClamD(ClamDConfig clamConfig) {
            this(ClamDScan.CLAMD, clamConfig);
        }

        private Process startClamd() throws IOException {
            Process clamd = new ProcessBuilder(new String[0]).command(this.clamdCommand, "-F", String.format("--config-file=%s", this.clamConfig.clamdConf.toAbsolutePath())).inheritIO().start();
            logger.info("Started clamd {} with config file {}", (Object)this.clamdCommand, (Object)this.clamConfig.clamdConf);
            return clamd;
        }

        @Override
        public void close() {
            if (this.clamd.isAlive()) {
                logger.info("Stopping ClamD");
                this.clamd.destroyForcibly();
            }
        }
    }
}

