/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.submitter;

import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unrealarchive.submitter.Submissions;

public class ClamScan {
    private static final Logger logger = LoggerFactory.getLogger(ClamScan.class);
    private static final String CLAMSCAN_OPTIONS = "-avr";
    private static final String CLAMSCAN = "clamscan";
    private static final Duration SCAN_TIMEOUT = Duration.ofSeconds(300L);
    private final String clamCommand;

    public ClamScan(String clamCommand) {
        this.clamCommand = clamCommand;
    }

    public ClamScan() {
        this(CLAMSCAN);
    }

    public ClamResult scan(Submissions.Job job, Path ... paths) {
        job.log(Submissions.JobState.VIRUS_SCANNING, "Scanning for malware");
        try {
            CharSequence[] clamCommand = this.clamCommand(paths);
            logger.info("Invoking clam scan with command {}", (Object)String.join((CharSequence)" ", clamCommand));
            Process process = new ProcessBuilder(new String[0]).command((String[])clamCommand).inheritIO().start();
            boolean b = process.waitFor(SCAN_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
            if (!b) {
                process.destroyForcibly().waitFor(SCAN_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
            }
            ClamResult clamResult = ClamResult.values()[process.exitValue()];
            switch (clamResult.ordinal()) {
                case 0: {
                    job.log(Submissions.JobState.VIRUS_FREE, "No malware found");
                    break;
                }
                case 1: {
                    job.log(Submissions.JobState.VIRUS_FOUND, "Malware found!!", new RuntimeException("Found some malware"));
                    break;
                }
                default: {
                    job.log(Submissions.JobState.VIRUS_ERROR, "Malware scan failed.", new RuntimeException("Malware scan failure"));
                }
            }
            return clamResult;
        }
        catch (Exception e) {
            logger.error("Malware scan failure", (Throwable)e);
            job.log(Submissions.JobState.VIRUS_ERROR, "Malware scan error.", new RuntimeException("Malware scan error"));
            return ClamResult.ERROR;
        }
    }

    protected String[] clamCommand(Path[] paths) {
        String[] cmd = new String[paths.length + 2];
        cmd[0] = this.clamCommand;
        cmd[1] = CLAMSCAN_OPTIONS;
        for (int i = 0; i < paths.length; ++i) {
            cmd[i + 2] = paths[0].toAbsolutePath().toString();
        }
        return cmd;
    }

    static enum ClamResult {
        OK,
        VIRUS,
        FAILED,
        ERROR;

    }
}

