/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.submitter;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.unrealarchive.submitter.ClamDScan;
import org.unrealarchive.submitter.ClamScan;
import org.unrealarchive.submitter.ContentRepository;
import org.unrealarchive.submitter.SubmissionProcessor;
import org.unrealarchive.submitter.WebApp;

public class Main {
    public static void main(String[] args) throws IOException, GitAPIException {
        ClamScan clamScan;
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2);
        ContentRepository contentRepo = new ContentRepository(System.getenv().getOrDefault("GIT_REPO", "https://github.com/unreal-archive/unreal-archive-data.git"), System.getenv().getOrDefault("GIT_USERNAME", ""), System.getenv().getOrDefault("GIT_PASSWORD", ""), System.getenv().getOrDefault("GIT_EMAIL", ""), System.getenv().getOrDefault("GH_TOKEN", ""), scheduler);
        if (!System.getenv().getOrDefault("CLAM_SOCKET", "").isEmpty()) {
            ClamDScan.ClamDConfig clamConfig = new ClamDScan.ClamDConfig(Paths.get(System.getenv().getOrDefault("CLAM_SOCKET", Files.createTempDirectory("clamd", new FileAttribute[0]).resolve("clamd.ctl").toString()), new String[0]));
            ClamDScan.ClamD[] clamd = new ClamDScan.ClamD[]{null};
            if (!System.getenv().containsKey("CLAM_SOCKET")) {
                clamd[0] = new ClamDScan.ClamD(clamConfig);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                clamConfig.close();
                if (clamd[0] != null) {
                    clamd[0].close();
                }
            }));
            clamScan = new ClamDScan(clamConfig);
        } else {
            clamScan = new ClamScan();
        }
        Path jobsPath = Files.createDirectories(Paths.get(System.getenv().getOrDefault("JOBS_PATH", "/tmp"), new String[0]), new FileAttribute[0]);
        Path uploadPath = Files.createDirectories(Paths.get(System.getenv().getOrDefault("UPLOAD_PATH", "/tmp/ua-submit-files"), new String[0]), new FileAttribute[0]);
        SubmissionProcessor subProcessor = new SubmissionProcessor(contentRepo, clamScan, 5, scheduler, jobsPath);
        WebApp webApp = new WebApp(InetSocketAddress.createUnresolved(System.getenv().getOrDefault("BIND_HOST", "localhost"), Integer.parseInt(System.getenv().getOrDefault("BIND_PORT", "8081"))), subProcessor, uploadPath, System.getenv().getOrDefault("ALLOWED_ORIGIN", "*"));
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            webApp.close();
            contentRepo.close();
            scheduler.shutdownNow();
        }));
    }
}

