/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.submitter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.form.EagerFormParsingHandler;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.handlers.form.MultiPartParserDefinition;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unrealarchive.common.ArchiveUtil;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.addons.SimpleAddonType;
import org.unrealarchive.submitter.SubmissionProcessor;
import org.unrealarchive.submitter.Submissions;
import org.xnio.Options;

public class WebApp
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(WebApp.class);
    private static final DateTimeFormatter DATE_FMT = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
    private static final int WORKER_IO_THREADS = 2;
    private static final int WORKER_TASK_CORE_THREADS = 10;
    private static final String HTTP_UPLOAD = "/upload";
    private static final String HTTP_JOB = "/job/{jobId}";
    private static final String HTTP_STATUS = "/status";
    private static final Path[] PATH_ARRAY = new Path[0];
    private final ObjectMapper MAPPER = new ObjectMapper();
    private final Path uploadPath;
    private final Undertow server;
    private final String allowOrigins;

    public WebApp(InetSocketAddress bindAddress, SubmissionProcessor submissionProcessor, Path uploadPath, String allowOrigins) throws IOException {
        this.uploadPath = Files.createDirectories(uploadPath.resolve("incoming"), new FileAttribute[0]);
        this.allowOrigins = allowOrigins;
        RoutingHandler handler = Handlers.routing().add("OPTIONS", HTTP_UPLOAD, this.corsOptionsHandler("POST, OPTIONS")).add("POST", HTTP_UPLOAD, this.uploadHandler(submissionProcessor, this.uploadPath)).add("OPTIONS", HTTP_JOB, this.corsOptionsHandler("GET, OPTIONS")).add("GET", HTTP_JOB, this.jobHandler(submissionProcessor)).add("GET", HTTP_STATUS, this.statusHandler(submissionProcessor));
        this.server = Undertow.builder().setWorkerOption(Options.WORKER_IO_THREADS, (Object)2).setWorkerOption(Options.WORKER_TASK_CORE_THREADS, (Object)10).setWorkerOption(Options.WORKER_TASK_MAX_THREADS, (Object)10).setWorkerOption(Options.TCP_NODELAY, (Object)true).setSocketOption(Options.WORKER_IO_THREADS, (Object)2).setSocketOption(Options.TCP_NODELAY, (Object)true).setSocketOption(Options.REUSE_ADDRESSES, (Object)true).addHttpListener(bindAddress.getPort(), bindAddress.getHostString()).setHandler((HttpHandler)handler).build();
        this.server.start();
        logger.info("Server started on host {}", (Object)bindAddress);
    }

    @Override
    public void close() {
        this.server.stop();
        try {
            logger.info("Cleaning upload path {}", (Object)this.uploadPath);
            ArchiveUtil.cleanPath((Path)this.uploadPath);
        }
        catch (IOException e) {
            logger.error("Cleanup failed", (Throwable)e);
        }
    }

    private HttpHandler corsOptionsHandler(String methods) {
        return exchange -> {
            exchange.getResponseHeaders().put(new HttpString("Access-Control-Allow-Origin"), this.allowOrigins).put(new HttpString("Access-Control-Allow-Methods"), methods);
            exchange.getResponseSender().close();
        };
    }

    private HttpHandler uploadHandler(SubmissionProcessor subProcessor, Path tmpDir) {
        HttpHandler multipartProcessorHandler = exchange -> exchange.dispatch(() -> {
            try {
                FormData attachment = (FormData)exchange.getAttachment(FormDataParser.FORM_DATA);
                SimpleAddonType forceType = null;
                FormData.FormValue maybeForceType = attachment.getFirst("forceType");
                if (maybeForceType != null && maybeForceType.getValue() != null && !maybeForceType.getValue().isBlank()) {
                    forceType = SimpleAddonType.valueOf((String)maybeForceType.getValue().toUpperCase());
                }
                Submissions.Job job = new Submissions.Job(forceType);
                subProcessor.trackJob(job);
                List<Path> files = attachment.get("files").stream().map(v -> {
                    try {
                        Path file = v.getFileItem().getFile();
                        String newName = String.format("%s.%s", Util.plainName((String)v.getFileName()), Util.extension((String)v.getFileName()));
                        Path savePath = Files.createDirectories(tmpDir.resolve(Util.hash((Path)file).substring(0, 8)), new FileAttribute[0]);
                        return Files.setPosixFilePermissions(Files.move(file, savePath.resolve(newName), StandardCopyOption.REPLACE_EXISTING), Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.OTHERS_READ));
                    }
                    catch (IOException e) {
                        job.log(Submissions.JobState.FAILED, String.format("Failed moving file %s", v.getFileName()), e);
                        logger.error("File move failed", (Throwable)e);
                        return null;
                    }
                }).filter(Objects::nonNull).toList();
                if (!files.isEmpty()) {
                    job.log(String.format("Received file(s): %s, queue for processing", files.stream().map(Util::fileName).collect(Collectors.joining(", "))));
                    subProcessor.add(new SubmissionProcessor.PendingSubmission(job, System.currentTimeMillis(), Util.fileName((Path)files.getFirst()), files.toArray(PATH_ARRAY)));
                }
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json").put(new HttpString("Access-Control-Allow-Origin"), this.allowOrigins).put(new HttpString("Access-Control-Allow-Methods"), "POST");
                exchange.getResponseSender().send(this.MAPPER.writeValueAsString((Object)job.id));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                exchange.endExchange();
            }
        });
        return new EagerFormParsingHandler(FormParserFactory.builder().addParsers(new FormParserFactory.ParserDefinition[]{new MultiPartParserDefinition()}).build()).setNext(multipartProcessorHandler);
    }

    private HttpHandler jobHandler(SubmissionProcessor submissionProcessor) {
        ArrayDeque emptyDeque = new ArrayDeque();
        return exchange -> {
            String jobId = (String)exchange.getQueryParameters().getOrDefault("jobId", emptyDeque).getFirst();
            Submissions.Job job = submissionProcessor.job(jobId);
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json").put(new HttpString("Access-Control-Allow-Origin"), this.allowOrigins).put(new HttpString("Access-Control-Allow-Methods"), "POST, GET");
            exchange.dispatch(() -> {
                try {
                    if (job == null) {
                        exchange.setStatusCode(404);
                        exchange.getResponseSender().send("[]");
                        return;
                    }
                    Deque catchup = exchange.getQueryParameters().getOrDefault("catchup", emptyDeque);
                    if (!catchup.isEmpty() && ((String)catchup.getFirst()).equals("1")) {
                        exchange.getResponseSender().send(this.MAPPER.writeValueAsString(job.log));
                    } else {
                        exchange.getResponseSender().send(this.MAPPER.writeValueAsString(job.pollLog(Duration.ofSeconds(15L))));
                    }
                }
                catch (JsonProcessingException | InterruptedException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    exchange.endExchange();
                }
            });
        };
    }

    private HttpHandler statusHandler(SubmissionProcessor submissionProcessor) {
        return exchange -> {
            StringBuilder html = new StringBuilder("<html><title>Job History</title><body><pre>");
            html.append(String.format("<b>%-8s %-20s %-20s %-20s %s</b>\n", "Job", "Created", "Updated", "State", "Last Update"));
            html.append("<hr/>");
            submissionProcessor.jobs().stream().sorted(Comparator.comparingLong(j -> j.logHead().time)).forEach(j -> {
                html.append(String.format("<a href='job/%s?catchup=1'>%s</a>", j.id, j.id));
                html.append(String.format(" %-20s", LocalDateTime.ofInstant(Instant.ofEpochMilli(j.logHead().time), ZoneId.systemDefault()).format(DATE_FMT)));
                html.append(String.format(" %-20s", LocalDateTime.ofInstant(Instant.ofEpochMilli(j.logTail().time), ZoneId.systemDefault()).format(DATE_FMT)));
                html.append(String.format(" %-21s", new Object[]{j.state}));
                html.append(j.logTail().message);
                html.append("\n");
            });
            html.append("</pre></body></html>");
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/html");
            exchange.dispatch(() -> {
                try {
                    exchange.getResponseSender().send(html.toString());
                }
                finally {
                    exchange.endExchange();
                }
            });
        };
    }
}

