/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.www;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.docs.Document;
import org.unrealarchive.content.docs.DocumentRepository;
import org.unrealarchive.www.Markdown;
import org.unrealarchive.www.PageGenerator;
import org.unrealarchive.www.SiteFeatures;
import org.unrealarchive.www.SiteMap;
import org.unrealarchive.www.Templates;

public class Documents
implements PageGenerator {
    private static final String SECTION = "Guides & Reference";
    private final DocumentRepository documents;
    private final Path root;
    private final Path staticRoot;
    private final SiteFeatures features;

    public Documents(DocumentRepository documents, Path root, Path staticRoot, SiteFeatures features) {
        this.documents = documents;
        this.root = root;
        this.staticRoot = staticRoot;
        this.features = features;
    }

    private Map<String, Game> loadGames(DocumentRepository documents) {
        HashMap<String, Game> groups = new HashMap<String, Game>();
        documents.all().stream().filter(d -> d.published).sorted(Comparator.reverseOrder()).forEach(d -> {
            Game game = groups.computeIfAbsent(d.game, x$0 -> new Game((String)x$0));
            game.add((Document)d);
        });
        return groups;
    }

    @Override
    public Set<SiteMap.Page> generate() {
        Map<String, Game> games = this.loadGames(this.documents);
        Templates.PageSet pages = new Templates.PageSet("documents", this.features, this.root, this.staticRoot);
        try {
            for (Game game : games.values()) {
                pages.add("game.ftl", SiteMap.Page.monthly(0.7f), String.join((CharSequence)" / ", game.name, SECTION)).put("game", game).write(game.path.resolve("index.html"));
                for (Group g : game.groups.values()) {
                    this.generateGroup(pages, g);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to render pages", e);
        }
        return pages.pages;
    }

    private void generateGroup(Templates.PageSet pages, Group group) throws IOException {
        pages.add("group.ftl", SiteMap.Page.monthly(0.7f), String.join((CharSequence)" / ", group.game.name, SECTION, group.name)).put("group", group).write(group.path.resolve("index.html"));
        for (SubGroup subgroup : group.subGroups.values()) {
            pages.add("subgroup.ftl", SiteMap.Page.monthly(0.75f), String.join((CharSequence)" / ", group.game.name, SECTION, group.name, subgroup.name)).put("subgroup", subgroup).write(subgroup.path.resolve("index.html"));
            for (DocumentInfo content : subgroup.documents) {
                this.generateDocument(pages, content);
            }
        }
    }

    private void generateDocument(Templates.PageSet pages, DocumentInfo doc) throws IOException {
        try (ReadableByteChannel docChan = this.documents.document(doc.document);){
            Path path = Files.createDirectories(doc.path, new FileAttribute[0]);
            this.documents.writeContent(doc.document, path);
            String page = Markdown.renderMarkdown(docChan);
            pages.add("document.ftl", SiteMap.Page.monthly(0.85f, doc.document.updatedDate), String.join((CharSequence)" / ", doc.subGroup.parent.game.name, SECTION, doc.subGroup.parent.name, doc.subGroup.name, doc.document.title)).put("document", doc).put("page", page).write(doc.document.pagePath(this.root));
        }
    }

    public class Game {
        public final String name;
        public final String slug;
        public final Path root;
        public final Path path;
        public final TreeMap<String, Group> groups = new TreeMap();
        public int count;

        public Game(String name) {
            this.name = name;
            this.slug = Util.slug((String)name);
            this.root = Documents.this.root.resolve(this.slug);
            this.path = this.root.resolve("documents");
            this.count = 0;
        }

        public void add(Document d) {
            this.groups.computeIfAbsent(d.group, g -> new Group(this, (String)g)).add(d);
            ++this.count;
        }
    }

    public class Group {
        public final String name;
        public final String slug;
        public final Path path;
        public final Game game;
        public final TreeMap<String, SubGroup> subGroups = new TreeMap();
        public int count;

        public Group(Game game, String name) {
            this.game = game;
            this.name = name;
            this.slug = Util.slug((String)name);
            this.path = game.path.resolve(this.slug);
            this.count = 0;
        }

        public void add(Document d) {
            this.subGroups.computeIfAbsent(d.subGroup, g -> new SubGroup(this, (String)g)).add(d);
            ++this.count;
        }
    }

    public class SubGroup {
        public final String name;
        public final String slug;
        public final Path path;
        public final Group parent;
        public final List<DocumentInfo> documents = new ArrayList<DocumentInfo>();
        public int count;

        public SubGroup(Group parent, String name) {
            this.parent = parent;
            this.name = name;
            this.slug = Util.slug((String)name);
            this.path = parent.path.resolve(this.slug);
            this.count = 0;
        }

        public void add(Document d) {
            this.documents.add(new DocumentInfo(Documents.this, d, this));
            ++this.count;
        }
    }

    public class DocumentInfo {
        public final Document document;
        public final SubGroup subGroup;
        public final String slug;
        public final Path path;

        public DocumentInfo(Documents this$0, Document document, SubGroup subGroup) {
            this.document = document;
            this.subGroup = subGroup;
            this.slug = Util.slug((String)document.title);
            this.path = document.slugPath(this$0.root);
        }
    }
}

