/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.www;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.unrealarchive.common.JSON;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.ContentEntity;
import org.unrealarchive.content.FileType;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.GameType;
import org.unrealarchive.content.addons.GameTypeRepository;
import org.unrealarchive.content.addons.SimpleAddonRepository;
import org.unrealarchive.content.wiki.WikiPage;
import org.unrealarchive.content.wiki.WikiRepository;
import org.unrealarchive.www.Wiki;
import org.unrealarchive.www.content.Packages;

public class MESSubmitter {
    private static final String ADD_ENDPOINT = "/index/add";
    private static final String ADD_BATCH_ENDPOINT = "/index/addBatch";

    public void submit(SimpleAddonRepository contentRepo, GameTypeRepository gametypeRepo, String rootUrl, String mseUrl, String mseToken, int batchSize, Consumer<Double> progress, Consumer<Boolean> done) throws IOException {
        HashSet contents = new HashSet();
        contents.addAll(contentRepo.all(false));
        contents.addAll(gametypeRepo.all());
        Path root = Paths.get("", new String[0]);
        int count = contents.size();
        int i = 0;
        ArrayList<Map<String, Map<String, String>>> batchDocs = new ArrayList<Map<String, Map<String, String>>>(batchSize);
        for (ContentEntity content : contents) {
            Map<String, Map<String, String>> doc = Map.of("id", content.id(), "score", content instanceof GameType ? 2.0 : 1.0, "fields", Map.of("name", content.name().replaceAll("-", "\\\\-"), "game", content.game(), "type", content.friendlyType(), "author", content.authorName().replaceAll("-", "\\\\-"), "url", rootUrl + "/" + content.pagePath(root).toString(), "date", content.releaseDate(), "description", content.autoDescription(), "image", content.leadImage(), "keywords", String.join((CharSequence)" ", content.autoTags())));
            batchDocs.add(doc);
            if (batchDocs.size() >= batchSize) {
                MESSubmitter.post(mseUrl + ADD_BATCH_ENDPOINT, mseToken, JSON.toString(Map.of("docs", batchDocs)));
                batchDocs.clear();
            }
            if (++i % 1000 != 0) continue;
            progress.accept((double)i / (double)count);
        }
        progress.accept(1.0);
        done.accept(true);
    }

    public void submitPackages(SimpleAddonRepository contentRepo, GameTypeRepository gametypeRepo, String rootUrl, String mseUrl, String mseToken, int batchSize, Consumer<Double> progress, Consumer<Boolean> done) {
        Map<Games, Map<String, Map<Addon.ContentFile, List<ContentEntity<?>>>>> contents = Packages.loadContentFiles(contentRepo, gametypeRepo);
        int count = contents.values().stream().mapToInt(p -> p.keySet().size()).sum();
        int[] i = new int[]{0};
        ArrayList batchDocs = new ArrayList(batchSize);
        contents.forEach((game, content) -> content.forEach((pkg, file) -> {
            Map<String, Map<String, String>> doc = Map.of("id", String.format("%s_%s", Util.slug((String)game.name()), Util.slug((String)pkg)), "score", 1.0, "fields", Map.of("name", pkg, "fileName", (Serializable)((Object)file.keySet().stream().findFirst().map(c -> c.name).orElse((String)pkg)), "game", game.name, "type", (Serializable)((Object)file.keySet().stream().map(f -> FileType.forFile((String)f.name)).filter(Objects::nonNull).distinct().map(Enum::name).collect(Collectors.joining(", "))), "versions", file.size(), "uses", file.values().stream().mapToInt(List::size).sum(), "url", String.format("/%s/packages/%s/index.html", Util.slug((String)game.name), Util.slug((String)pkg)), "keywords", String.join((CharSequence)" ", game.tags)));
            batchDocs.add(doc);
            if (batchDocs.size() >= batchSize) {
                try {
                    MESSubmitter.post(mseUrl + ADD_BATCH_ENDPOINT, mseToken, JSON.toString(Map.of("docs", batchDocs)));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                batchDocs.clear();
            }
            i[0] = i[0] + 1;
            if (i[0] % 1000 == 0) {
                progress.accept((double)i[0] / (double)count);
            }
        }));
        progress.accept(1.0);
        done.accept(true);
    }

    public void submit(WikiRepository wikiManager, String rootUrl, String mseUrl, String mseToken, int batchSize, Consumer<Double> progress, Consumer<Boolean> done) throws IOException {
        Set<String> stopWords = MESSubmitter.stopWords();
        for (WikiRepository.Wiki wiki : wikiManager.all()) {
            int i = 0;
            Set candidates = wiki.all().parallelStream().filter(p -> p.parse.categories.stream().noneMatch(c -> wiki.skipCategories.stream().anyMatch(c.name::contains))).filter(p -> p.parse.templates.stream().noneMatch(c -> wiki.skipTemplates.stream().anyMatch(c.name::contains))).collect(Collectors.toSet());
            ArrayList<Map<String, Map<String, String>>> batchDocs = new ArrayList<Map<String, Map<String, String>>>(batchSize);
            for (WikiPage page : candidates) {
                Document document = Jsoup.parse((String)page.parse.text.text);
                document.outputSettings().prettyPrint(false);
                Wiki.sanitisedPageHtml(document, wiki);
                document.select("pre").remove();
                document.select(".toc").remove();
                document.select(".navbox").remove();
                document.select(".infobox-class").remove();
                Object content = document.select("body").text().toLowerCase();
                content = ((String)content).replaceAll("[^A-Za-z0-9-'\" ]", "");
                content = " " + (String)content + " ";
                for (String s : stopWords) {
                    content = ((String)content).replaceAll(" " + s + " ", " ");
                }
                Map<String, Map<String, String>> doc = Map.of("id", wiki.name + page.name, "score", 1.0, "fields", Map.of("name", page.name.replaceAll("-", "\\\\-"), "wiki", wiki.name, "url", String.format("%s/wikis/%s/%s.html", rootUrl, Util.slug((String)wiki.name), page.name.replaceAll(" ", "_")), "content", ((String)content).trim()));
                batchDocs.add(doc);
                if (batchDocs.size() >= batchSize) {
                    MESSubmitter.post(mseUrl + ADD_BATCH_ENDPOINT, mseToken, JSON.toString(Map.of("docs", batchDocs)));
                    batchDocs.clear();
                }
                if (++i % 100 != 0) continue;
                progress.accept((double)i / (double)candidates.size());
            }
        }
    }

    private static Set<String> stopWords() throws IOException {
        try (InputStream stopwords = MESSubmitter.class.getResourceAsStream("stopWords.txt");){
            Set<String> set;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(stopwords));){
                set = br.lines().map(String::trim).filter(s -> !s.isBlank() && !s.startsWith("#")).collect(Collectors.toSet());
            }
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean post(String url, String token, String payload) throws IOException {
        URL urlConnection = Util.url((String)url);
        HttpURLConnection httpConn = (HttpURLConnection)urlConnection.openConnection();
        httpConn.setRequestMethod("POST");
        httpConn.setRequestProperty("Authorization", String.format("bearer %s", token));
        httpConn.setRequestProperty("Content-Length", Long.toString(payload.length()));
        httpConn.setDoOutput(true);
        httpConn.connect();
        try {
            try (OutputStreamWriter wr = new OutputStreamWriter(httpConn.getOutputStream(), StandardCharsets.UTF_8);){
                wr.write(payload);
                wr.flush();
            }
            int response = httpConn.getResponseCode();
            boolean bl = response >= 200 && response <= 299;
            return bl;
        }
        finally {
            String connection = httpConn.getHeaderField("Connection");
            if (connection == null || connection.equals("Close")) {
                httpConn.disconnect();
            }
        }
    }
}

