/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.www;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import org.unrealarchive.common.CLI;
import org.unrealarchive.common.Version;
import org.unrealarchive.content.AuthorNames;
import org.unrealarchive.content.RepoFactory;
import org.unrealarchive.content.addons.GameTypeRepository;
import org.unrealarchive.content.addons.SimpleAddonRepository;
import org.unrealarchive.content.docs.DocumentRepository;
import org.unrealarchive.content.managed.ManagedContentRepository;
import org.unrealarchive.content.wiki.WikiRepository;
import org.unrealarchive.www.Documents;
import org.unrealarchive.www.Index;
import org.unrealarchive.www.MESSubmitter;
import org.unrealarchive.www.ManagedContent;
import org.unrealarchive.www.PageGenerator;
import org.unrealarchive.www.SiteFeatures;
import org.unrealarchive.www.SiteMap;
import org.unrealarchive.www.Templates;
import org.unrealarchive.www.Wiki;
import org.unrealarchive.www.content.Announcers;
import org.unrealarchive.www.content.Authors;
import org.unrealarchive.www.content.FileDetails;
import org.unrealarchive.www.content.GameTypes;
import org.unrealarchive.www.content.Latest;
import org.unrealarchive.www.content.MapPacks;
import org.unrealarchive.www.content.Maps;
import org.unrealarchive.www.content.Models;
import org.unrealarchive.www.content.Mutators;
import org.unrealarchive.www.content.Packages;
import org.unrealarchive.www.content.Skins;
import org.unrealarchive.www.content.Voices;
import org.unrealarchive.www.features.Search;
import org.unrealarchive.www.features.Submit;
import org.unrealarchive.www.features.UmodRepack;

public class Main {
    public static void main(String[] args) throws IOException {
        System.err.printf("Unreal Archive WWW version %s%n", Version.version());
        CLI cli = CLI.parse(Collections.emptyMap(), (String[])args);
        if (cli.commands().length == 0) {
            Main.usage();
            System.exit(1);
        }
        switch (cli.commands()[0].toLowerCase()) {
            case "www": {
                Main.www(RepoFactory.contentRepo((CLI)cli), RepoFactory.gameTypeRepo((CLI)cli), RepoFactory.documentRepo((CLI)cli), RepoFactory.managedRepo((CLI)cli), RepoFactory.wikiRepo((CLI)cli), cli);
                break;
            }
            case "search-submit": {
                Main.searchSubmit(RepoFactory.contentRepo((CLI)cli), RepoFactory.gameTypeRepo((CLI)cli), RepoFactory.documentRepo((CLI)cli), RepoFactory.managedRepo((CLI)cli), RepoFactory.wikiRepo((CLI)cli), cli);
                break;
            }
            case "summary": {
                System.out.println(RepoFactory.contentRepo((CLI)cli).summary());
                break;
            }
            default: {
                System.out.printf("Command \"%s\" does not exist!%n%n", cli.commands()[0]);
                Main.usage();
            }
        }
        System.exit(0);
    }

    private static void www(SimpleAddonRepository contentRepo, GameTypeRepository gameTypeRepo, DocumentRepository documentRepo, ManagedContentRepository managedRepo, WikiRepository wikiRepo, CLI cli) throws IOException {
        Path outputPath;
        if (cli.commands().length < 2) {
            System.err.println("An output path must be specified!");
            System.exit(2);
        }
        if (!Files.exists(outputPath = Paths.get(cli.commands()[1], new String[0]).toAbsolutePath(), new LinkOption[0])) {
            System.out.println("Creating directory " + String.valueOf(outputPath));
            Files.createDirectories(outputPath, new FileAttribute[0]);
        } else if (!Files.isDirectory(outputPath, new LinkOption[0])) {
            System.err.println("Output path must be a directory!");
            System.exit(4);
        }
        boolean withSearch = Boolean.parseBoolean(cli.option("with-search", "false"));
        boolean withSubmit = Boolean.parseBoolean(cli.option("with-submit", "false"));
        boolean withLatest = Boolean.parseBoolean(cli.option("with-latest", "false"));
        boolean withFiles = Boolean.parseBoolean(cli.option("with-files", "true"));
        boolean withPackages = Boolean.parseBoolean(cli.option("with-packages", "false"));
        boolean withWikis = Boolean.parseBoolean(cli.option("with-wikis", "false"));
        boolean withUmod = Boolean.parseBoolean(cli.option("with-umod", "false"));
        boolean localImages = Boolean.parseBoolean(cli.option("local-images", "false"));
        if (localImages) {
            System.out.println("Will download a local copy of content images, this will take additional time.");
        }
        SiteFeatures features = new SiteFeatures(localImages, withLatest, withSubmit, withSearch, withFiles, withWikis, withUmod);
        Path staticOutput = outputPath.resolve("static");
        long start = System.currentTimeMillis();
        Templates.unpackResources("static.list", Files.createDirectories(staticOutput, new FileAttribute[0]).getParent());
        Path authorPath = RepoFactory.contentPathHelper((CLI)cli).resolve("authors");
        AuthorNames names = new AuthorNames(authorPath);
        contentRepo.all().parallelStream().filter(c -> !"Unknown".equalsIgnoreCase(c.author())).sorted(Comparator.comparingInt(a -> a.author().length())).forEachOrdered(c -> names.maybeAutoAlias(c.author));
        AuthorNames.instance = names;
        System.out.printf("Found %d author aliases and names%n", names.aliasCount());
        ConcurrentHashMap.KeySetView allPages = ConcurrentHashMap.newKeySet();
        HashSet<PageGenerator> generators = new HashSet<PageGenerator>();
        generators.add(new Index(contentRepo, gameTypeRepo, documentRepo, managedRepo, outputPath, staticOutput, features));
        if (cli.commands().length == 2 || cli.commands().length > 2 && cli.commands()[2].equalsIgnoreCase("content")) {
            generators.addAll(Arrays.asList(new Maps(contentRepo, outputPath, staticOutput, features, gameTypeRepo), new MapPacks(contentRepo, outputPath, staticOutput, features, gameTypeRepo), new Skins(contentRepo, outputPath, staticOutput, features), new Models(contentRepo, outputPath, staticOutput, features), new Voices(contentRepo, outputPath, staticOutput, features), new Mutators(contentRepo, outputPath, staticOutput, features), new Announcers(contentRepo, outputPath, staticOutput, features)));
            if (withPackages) {
                generators.add(new Packages(contentRepo, gameTypeRepo, managedRepo, outputPath, staticOutput, features));
            }
        }
        if (cli.commands().length == 2 || cli.commands().length > 2 && cli.commands()[2].equalsIgnoreCase("authors")) {
            generators.add(new Authors(names, contentRepo, gameTypeRepo, managedRepo, outputPath, staticOutput, features));
        }
        if (cli.commands().length == 2 || cli.commands().length > 2 && cli.commands()[2].equalsIgnoreCase("docs")) {
            generators.add(new Documents(documentRepo, outputPath, staticOutput, features));
        }
        if (cli.commands().length == 2 || cli.commands().length > 2 && cli.commands()[2].equalsIgnoreCase("managed")) {
            generators.add(new ManagedContent(managedRepo, outputPath, staticOutput, features));
        }
        if (cli.commands().length == 2 || cli.commands().length > 2 && cli.commands()[2].equalsIgnoreCase("gametypes")) {
            generators.add(new GameTypes(gameTypeRepo, contentRepo, outputPath, staticOutput, features));
        }
        if (cli.commands().length > 2 && cli.commands()[2].equalsIgnoreCase("packages")) {
            generators.add(new Packages(contentRepo, gameTypeRepo, managedRepo, outputPath, staticOutput, features));
        }
        if (features.wikis || cli.commands().length > 2 && cli.commands()[2].equalsIgnoreCase("wiki")) {
            generators.add(new Wiki(outputPath, staticOutput, features, wikiRepo));
        }
        if (features.submit) {
            generators.add(new Submit(outputPath, staticOutput, features));
        }
        if (features.search) {
            generators.add(new Search(outputPath, staticOutput, features));
        }
        if (features.umod) {
            generators.add(new UmodRepack(outputPath, staticOutput, features));
        }
        if (features.latest) {
            generators.add(new Latest(contentRepo, gameTypeRepo, managedRepo, outputPath, staticOutput, features));
        }
        if (features.files) {
            generators.add(new FileDetails(contentRepo, outputPath, staticOutput, features));
        }
        try (ForkJoinPool myPool = new ForkJoinPool(Integer.parseInt(cli.option("concurrency", "4")));){
            ((ForkJoinTask)myPool.submit(() -> generators.parallelStream().forEach(g -> {
                System.out.printf("Generating %s pages%n", g.getClass().getSimpleName());
                allPages.addAll(g.generate());
            }))).join();
        }
        System.out.println("Generating sitemap");
        allPages.addAll(SiteMap.siteMap(SiteMap.SITE_ROOT, outputPath, allPages, 50000, features).generate());
        System.out.printf("Output %d pages in %.2fs%n", allPages.size(), Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f));
    }

    private static void searchSubmit(SimpleAddonRepository contentRepo, GameTypeRepository gameTypeRepo, DocumentRepository documentRepo, ManagedContentRepository managedContentManager, WikiRepository wikiManager, CLI cli) throws IOException {
        Path authorPath = RepoFactory.contentPathHelper((CLI)cli).resolve("authors");
        AuthorNames names = new AuthorNames(authorPath);
        contentRepo.all().parallelStream().filter(c -> !"Unknown".equalsIgnoreCase(c.author())).sorted(Comparator.comparingInt(a -> a.author().length())).forEachOrdered(c -> names.maybeAutoAlias(c.author));
        AuthorNames.instance = names;
        long start = System.currentTimeMillis();
        MESSubmitter submitter = new MESSubmitter();
        System.out.printf("Submitting content to search instance at %s%n", System.getenv().getOrDefault("MSE_CONTENT_URL", System.getenv().getOrDefault("MSE_URL", "")));
        submitter.submit(contentRepo, gameTypeRepo, System.getenv().getOrDefault("SITE_URL", ""), System.getenv().getOrDefault("MES_CONTENT_URL", System.getenv().getOrDefault("MES_URL", "")), System.getenv().getOrDefault("MES_CONTENT_TOKEN", System.getenv().getOrDefault("MES_TOKEN", "")), 200, percent -> System.out.printf("\r%.1f%% complete contents", percent * 100.0), done -> System.out.printf("%nContent search submission complete in %.2fs%n", Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f)));
        System.out.printf("Submitting wikis to search instance at %s%n", System.getenv().getOrDefault("MES_WIKI_URL", ""));
        submitter.submit(wikiManager, System.getenv().getOrDefault("SITE_URL", ""), System.getenv().getOrDefault("MES_WIKI_URL", ""), System.getenv().getOrDefault("MES_WIKI_TOKEN", ""), 50, percent -> System.out.printf("\r%.1f%% complete wikis", percent * 100.0), done -> System.out.printf("%nWiki search submission complete in %.2fs%n", Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f)));
        submitter.submitPackages(contentRepo, gameTypeRepo, System.getenv().getOrDefault("SITE_URL", ""), System.getenv().getOrDefault("MES_PACKAGE_URL", ""), System.getenv().getOrDefault("MES_PACKAGE_TOKEN", ""), 500, percent -> System.out.printf("\r%.1f%% complete packages", percent * 100.0), done -> System.out.printf("%nPackage search submission complete in %.2fs%n", Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f)));
    }

    private static void usage() {
        System.out.println("Usage: www <command> [options]");
        System.out.println();
        System.out.println("Commands:");
        System.out.println("  www <output-path> [--content-path=<path> | --content-download]");
        System.out.println("    Generate the HTML website for browsing content.");
        System.out.println("  search-submit [--content-path=<path> | --content-download]");
        System.out.println("    Sync search metadata with a search service.");
        System.out.println("  summary [--content-path=<path> | --content-download]");
        System.out.println("    Show stats and counters for the content index in <content-path>");
    }

    static {
        Version.setVersion(Main.class);
    }
}

