/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.www;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.managed.Managed;
import org.unrealarchive.content.managed.ManagedContentRepository;
import org.unrealarchive.www.Markdown;
import org.unrealarchive.www.PageGenerator;
import org.unrealarchive.www.SiteFeatures;
import org.unrealarchive.www.SiteMap;
import org.unrealarchive.www.Templates;

public class ManagedContent
implements PageGenerator {
    private final ManagedContentRepository managedRepo;
    private final Path root;
    private final Path staticRoot;
    private final SiteFeatures features;

    public ManagedContent(ManagedContentRepository managedRepo, Path root, Path staticRoot, SiteFeatures features) {
        this.managedRepo = managedRepo;
        this.root = root;
        this.staticRoot = staticRoot;
        this.features = features;
    }

    private Map<String, Game> loadGames(ManagedContentRepository managedRepo) {
        HashMap<String, Game> games = new HashMap<String, Game>();
        managedRepo.all().stream().filter(d -> d.published).sorted(Comparator.reverseOrder()).toList().forEach(d -> {
            Game game = games.computeIfAbsent(d.game(), x$0 -> new Game((String)x$0));
            game.add((Managed)d);
        });
        return games;
    }

    @Override
    public Set<SiteMap.Page> generate() {
        Map<String, Game> games = this.loadGames(this.managedRepo);
        Templates.PageSet pages = new Templates.PageSet("managed", this.features, this.root, this.staticRoot);
        try {
            for (Game game : games.values()) {
                for (Group g : game.groups.values()) {
                    this.generateGroup(pages, g);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to render managed content pages", e);
        }
        return pages.pages;
    }

    private void generateGroup(Templates.PageSet pages, Group group) throws IOException {
        pages.add("group.ftl", SiteMap.Page.monthly(0.7f), String.join((CharSequence)" / ", group.game.name, group.name)).put("group", group).write(group.path.resolve("index.html"));
        for (SubGroup subgroup : group.subGroups.values()) {
            pages.add("subgroup.ftl", SiteMap.Page.monthly(0.75f), String.join((CharSequence)" / ", group.game.name, group.name, subgroup.name)).put("subgroup", subgroup).write(subgroup.path.resolve("index.html"));
            for (ContentInfo content : subgroup.content) {
                this.generateDocument(pages, content);
            }
        }
    }

    private void generateDocument(Templates.PageSet pages, ContentInfo content) throws IOException {
        try (ReadableByteChannel docChan = this.managedRepo.document(content.managed);){
            Path path = Files.createDirectories(content.path, new FileAttribute[0]);
            this.managedRepo.writeContent(content.managed, path);
            String page = Markdown.renderMarkdown(docChan);
            pages.add("content.ftl", SiteMap.Page.monthly(0.85f, content.managed.updatedDate), String.join((CharSequence)" / ", content.subGroup.parent.game.name, content.subGroup.parent.name, content.subGroup.name, content.managed.title)).put("managed", content).put("page", page).write(content.managed.pagePath(this.root));
        }
    }

    public class Game {
        public final String name;
        public final String slug;
        public final Path path;
        public final TreeMap<String, Group> groups = new TreeMap();
        public int count;

        public Game(String name) {
            this.name = name;
            this.slug = Util.slug((String)name);
            this.path = ManagedContent.this.root.resolve(this.slug);
            this.count = 0;
        }

        public void add(Managed m) {
            this.groups.computeIfAbsent(m.group, g -> new Group(this, (String)g)).add(m);
            ++this.count;
        }
    }

    public class Group {
        public final String name;
        public final String slug;
        public final Path path;
        public final Game game;
        public final TreeMap<String, SubGroup> subGroups = new TreeMap();
        public int count;

        public Group(Game game, String name) {
            this.game = game;
            this.name = name;
            this.slug = Util.slug((String)name);
            this.path = game.path.resolve(this.slug);
            this.count = 0;
        }

        public void add(Managed m) {
            this.subGroups.computeIfAbsent(m.subGroup, g -> new SubGroup(this, (String)g)).add(m);
            ++this.count;
        }
    }

    public class SubGroup {
        public final String name;
        public final String slug;
        public final Path path;
        public final Group parent;
        public final List<ContentInfo> content = new ArrayList<ContentInfo>();
        public int count;

        public SubGroup(Group parent, String name) {
            this.parent = parent;
            this.name = name;
            this.slug = Util.slug((String)name);
            this.path = parent.path.resolve(this.slug);
            this.count = 0;
        }

        public void add(Managed m) {
            this.content.add(new ContentInfo(ManagedContent.this, m, this));
            ++this.count;
        }
    }

    public class ContentInfo {
        public final Managed managed;
        public final SubGroup subGroup;
        public final String slug;
        public final Path path;
        public final Path indexPath;

        public ContentInfo(ManagedContent this$0, Managed managed, SubGroup subGroup) {
            this.managed = managed;
            this.subGroup = subGroup;
            this.slug = Util.slug((String)managed.title);
            this.path = managed.slugPath(this$0.root);
            this.indexPath = managed.pagePath(this$0.root);
        }
    }
}

