/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.www;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import org.unrealarchive.common.Util;

public class Thumbnails {
    public static Path thumbnail(Path source, Path dest, int maxWidth) throws IOException {
        if (Files.exists(dest, new LinkOption[0])) {
            return dest;
        }
        BufferedImage image = ImageIO.read(source.toFile());
        double scale = (double)maxWidth / (double)image.getWidth();
        BufferedImage thumb = new BufferedImage((int)((double)image.getWidth() * scale), (int)((double)image.getHeight() * scale), 1);
        Graphics2D graphics = thumb.createGraphics();
        graphics.drawImage(image.getScaledInstance(thumb.getWidth(), thumb.getHeight(), 4), 0, 0, null);
        ImageIO.write((RenderedImage)thumb, Util.extension((Path)source), dest.toFile());
        Files.setLastModifiedTime(dest, Files.getLastModifiedTime(source, new LinkOption[0]));
        return dest;
    }

    public static Path thumbnail(Path source, Path outDirectory, ThumbConfig conf) throws IOException {
        Path dest = outDirectory.resolve(String.format("%s_%s", conf.name, Util.fileName((Path)source)));
        return Thumbnails.thumbnail(source, dest, conf.maxWidth);
    }

    public static class ThumbConfig {
        public final Path path;
        public String name;
        public int maxWidth;
        public int maxHeight;
        public boolean noSubDirectories;

        public ThumbConfig(Path path, String config) {
            this.path = path;
            for (String param : config.split(";")) {
                if (param.matches("[a-zA-Z]+?=\\d+x\\d+")) {
                    String[] nameSize = param.split("=");
                    String[] widthHeight = nameSize[1].split("x");
                    this.name = nameSize[0];
                    this.maxWidth = Integer.parseInt(widthHeight[0]);
                    this.maxHeight = Integer.parseInt(widthHeight[1]);
                    continue;
                }
                if (!param.equalsIgnoreCase("nowalk")) continue;
                this.noSubDirectories = true;
            }
        }
    }
}

