/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.www.content;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.Announcer;
import org.unrealarchive.content.addons.SimpleAddonRepository;
import org.unrealarchive.www.SiteFeatures;
import org.unrealarchive.www.SiteMap;
import org.unrealarchive.www.Templates;
import org.unrealarchive.www.content.GenericContentPage;

public class Announcers
extends GenericContentPage<Announcer> {
    private static final String SECTION = "Announcers";
    private static final String SUBGROUP = "all";

    public Announcers(SimpleAddonRepository content, Path root, Path staticRoot, SiteFeatures localImages) {
        super(content, root, staticRoot, localImages);
    }

    @Override
    public Set<SiteMap.Page> generate() {
        GenericContentPage.GameList games = this.loadContent(Announcer.class, this.content, "announcers");
        Templates.PageSet pages = this.pageSet("content/announcers");
        games.games.entrySet().parallelStream().forEach(g -> {
            Map<Integer, Map<Integer, Integer>> timeline = this.timeline((GenericContentPage.Game)g.getValue());
            Games game = Games.byName((String)((String)g.getKey()));
            if (((GenericContentPage.Game)g.getValue()).count < 150) {
                List all = ((GenericContentPage.Game)g.getValue()).groups.get((Object)SUBGROUP).letters.values().stream().flatMap(l -> l.pages.stream()).flatMap(e -> e.items.stream()).sorted().toList();
                pages.add("listing.ftl", SiteMap.Page.weekly(0.65f), String.join((CharSequence)" / ", game.bigName, SECTION)).put("game", g.getValue()).put("timeline", timeline).put("announcers", all).write(((GenericContentPage.Game)g.getValue()).path.resolve("index.html"));
                all.parallelStream().forEach(announcer -> this.announcerPage(pages, (GenericContentPage.ContentInfo)announcer));
                this.generateTimeline(pages, timeline, (GenericContentPage.Game)g.getValue(), SECTION);
                return;
            }
            ((GenericContentPage.Game)g.getValue()).groups.get((Object)SUBGROUP).letters.entrySet().parallelStream().forEach(l -> {
                ((GenericContentPage.LetterGroup)l.getValue()).pages.parallelStream().forEach(p -> {
                    pages.add("listing.ftl", SiteMap.Page.weekly(0.65f), String.join((CharSequence)" / ", game.bigName, SECTION)).put("timeline", timeline).put("page", p).write(p.path.resolve("index.html"));
                    p.items.parallelStream().forEach(announcer -> this.announcerPage(pages, (GenericContentPage.ContentInfo)announcer));
                });
                pages.add("listing.ftl", SiteMap.Page.weekly(0.65f), String.join((CharSequence)" / ", game.bigName, SECTION)).put("timeline", timeline).put("page", ((GenericContentPage.LetterGroup)l.getValue()).pages.getFirst()).write(((GenericContentPage.LetterGroup)l.getValue()).path.resolve("index.html"));
            });
            pages.add("listing.ftl", SiteMap.Page.weekly(0.65f), String.join((CharSequence)" / ", game.bigName, SECTION)).put("timeline", timeline).put("page", ((GenericContentPage.Game)g.getValue()).groups.get((Object)SUBGROUP).letters.firstEntry().getValue().pages.get(0)).write(((GenericContentPage.Game)g.getValue()).path.resolve("index.html"));
            this.generateTimeline(pages, timeline, (GenericContentPage.Game)g.getValue(), SECTION);
        });
        return pages.pages;
    }

    private void announcerPage(Templates.PageSet pages, GenericContentPage.ContentInfo announcer) {
        Object item = announcer.item();
        this.localImages((Addon)item, this.root.resolve(announcer.path).getParent());
        pages.add("announcer.ftl", SiteMap.Page.monthly(0.9f, ((Addon)item).firstIndex), String.join((CharSequence)" / ", announcer.page.letter.group.game.game.bigName, SECTION, ((Addon)item).name)).put("announcer", announcer).write(Paths.get(String.valueOf(announcer.path) + ".html", new String[0]));
        for (GenericContentPage.ContentInfo variation : announcer.variations) {
            this.announcerPage(pages, variation);
        }
    }

    @Override
    protected String gameSubGroup(Announcer item) {
        return SUBGROUP;
    }
}

