/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.www.content;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.AuthorNames;
import org.unrealarchive.content.ContentEntity;
import org.unrealarchive.content.addons.GameTypeRepository;
import org.unrealarchive.content.addons.SimpleAddonRepository;
import org.unrealarchive.content.managed.ManagedContentRepository;
import org.unrealarchive.www.SiteFeatures;
import org.unrealarchive.www.SiteMap;
import org.unrealarchive.www.Templates;
import org.unrealarchive.www.content.ContentPageGenerator;

public class Authors
extends ContentPageGenerator {
    private static final String SECTION = "Authors";
    private final AuthorNames names;
    private final GameTypeRepository gameTypes;
    private final ManagedContentRepository managed;
    private final Path sectionPath;

    public Authors(AuthorNames names, SimpleAddonRepository content, GameTypeRepository gameTypes, ManagedContentRepository managed, Path root, Path staticRoot, SiteFeatures features) {
        super(content, root, staticRoot, features);
        this.names = names;
        this.gameTypes = gameTypes;
        this.managed = managed;
        this.sectionPath = root.resolve("authors");
    }

    private TreeMap<String, LetterGroup> loadLetters(AuthorNames names, SimpleAddonRepository content, GameTypeRepository gameTypes, ManagedContentRepository managed) {
        TreeMap<String, LetterGroup> letters = new TreeMap<String, LetterGroup>();
        Stream.concat(Stream.concat(content.all(false).stream(), gameTypes.all().stream()), managed.all().stream()).filter(c -> c.author().length() > 2).filter(c -> !c.author().equalsIgnoreCase("Unknown")).filter(c -> !c.author().equalsIgnoreCase("Various")).collect(Collectors.groupingBy(c -> names.cleanName(Util.normalised((String)c.author())).toLowerCase().replaceAll("[\"`()\\[\\]<>{}=*-]", "'"))).entrySet().stream().filter(c -> !((String)c.getKey()).equalsIgnoreCase("various")).sorted(Map.Entry.comparingByKey()).forEach(e -> {
            String authorName = names.cleanName(((ContentEntity)((List)e.getValue()).getFirst()).author());
            String pageLetter = this.pageSelection(authorName);
            if (pageLetter != null) {
                LetterGroup letter = letters.computeIfAbsent(pageLetter, x$0 -> new LetterGroup((String)x$0));
                letter.add(authorName, (List)e.getValue());
            }
        });
        return letters;
    }

    private String pageSelection(String author) {
        String normalised = Util.normalised((String)author).toUpperCase();
        if (normalised.startsWith("\"")) {
            normalised = normalised.substring(1);
        }
        if (normalised.startsWith("'")) {
            normalised = normalised.substring(1);
        }
        if (normalised.replaceAll("([^A-Za-z0-9])", "").trim().isBlank()) {
            return null;
        }
        int first = Character.isDigit(normalised.charAt(0)) ? 48 : (Character.isAlphabetic(normalised.charAt(0)) ? (int)normalised.charAt(0) : 95);
        return Character.toString((char)first);
    }

    @Override
    public Set<SiteMap.Page> generate() {
        TreeMap<String, LetterGroup> letters = this.loadLetters(this.names, this.content, this.gameTypes, this.managed);
        Templates.PageSet pages = this.pageSet("content/authors");
        letters.entrySet().parallelStream().forEach(l -> {
            ((LetterGroup)l.getValue()).pages.parallelStream().forEach(p -> {
                pages.add("listing.ftl", SiteMap.Page.weekly(0.65f), String.join((CharSequence)" / ", SECTION)).put("letters", letters).put("page", p).put("authorsPath", this.sectionPath).write(p.path.resolve("index.html"));
                p.authors.parallelStream().forEach(author -> this.authorPage(pages, (AuthorInfo)author));
            });
            pages.add("listing.ftl", SiteMap.Page.weekly(0.65f), String.join((CharSequence)" / ", SECTION)).put("letters", letters).put("page", ((LetterGroup)l.getValue()).pages.getFirst()).put("authorsPath", this.sectionPath).write(((LetterGroup)l.getValue()).path.resolve("index.html"));
        });
        pages.add("listing.ftl", SiteMap.Page.weekly(0.65f), String.join((CharSequence)" / ", SECTION)).put("letters", letters).put("page", letters.firstEntry().getValue().pages.getFirst()).put("authorsPath", this.sectionPath).write(this.sectionPath.resolve("index.html"));
        return pages.pages;
    }

    private void authorPage(Templates.PageSet pages, AuthorInfo author) {
        pages.add("author.ftl", SiteMap.Page.monthly(author.count > 2 ? 0.92f : 0.67f), String.join((CharSequence)" / ", SECTION, author.author)).put("author", author).put("authorsPath", this.sectionPath).write(Paths.get(author.path.toString() + ".html", new String[0]));
    }

    public class LetterGroup {
        public final String letter;
        public final Path path;
        public final List<Page> pages = new ArrayList<Page>();
        public int count = 0;

        public LetterGroup(String letter) {
            this.letter = letter;
            this.path = Authors.this.sectionPath.resolve(letter);
        }

        public void add(String author, List<ContentEntity<?>> contents) {
            if (this.pages.isEmpty()) {
                this.pages.add(new Page(this, 1));
            }
            Page page = this.pages.getLast();
            if (page.authors.size() == 150) {
                page = new Page(this, this.pages.size() + 1);
                this.pages.add(page);
            }
            page.add(author, contents);
            if (page.count > 0) {
                ++this.count;
            }
        }
    }

    public class AuthorInfo
    implements Comparable<AuthorInfo> {
        public final Page page;
        public final String author;
        public final Map<String, List<ContentEntity<?>>> contents;
        public final String slug;
        public final Path path;
        public final int count;
        public final String leadImage;

        public AuthorInfo(Page page, String author, List<ContentEntity<?>> contents) {
            this.page = page;
            this.author = author;
            this.contents = new HashMap<String, List<ContentEntity>>(contents.stream().sorted().collect(Collectors.groupingBy(ContentEntity::friendlyType)));
            this.slug = Util.authorSlug((String)author);
            this.path = Authors.this.sectionPath.resolve(this.slug);
            this.count = contents.size();
            ArrayList shuffled = new ArrayList(contents);
            Collections.shuffle(shuffled);
            this.leadImage = shuffled.stream().filter(e -> e.leadImage() != null && !e.leadImage().isBlank()).map(ContentEntity::leadImage).findAny().map(i -> {
                if (i.contains("://")) {
                    return i;
                }
                return this.path.relativize(Authors.this.root.resolve((String)i)).toString();
            }).orElse(null);
        }

        @Override
        public int compareTo(AuthorInfo o) {
            return this.author.toLowerCase().compareTo(o.author.toLowerCase());
        }
    }

    public class Page {
        public final LetterGroup letter;
        public final int number;
        public final Path path;
        public final List<AuthorInfo> authors = new ArrayList<AuthorInfo>();
        public int count;

        public Page(LetterGroup letter, int number) {
            this.letter = letter;
            this.number = number;
            this.path = letter.path.resolve(Integer.toString(number));
        }

        public void add(String author, List<ContentEntity<?>> contents) {
            this.authors.add(new AuthorInfo(this, author, contents));
            Collections.sort(this.authors);
            if (contents.size() > 1) {
                ++this.count;
            }
        }
    }
}

