/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.www.content;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.FileType;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.SimpleAddonRepository;
import org.unrealarchive.www.SiteFeatures;
import org.unrealarchive.www.SiteMap;
import org.unrealarchive.www.Templates;
import org.unrealarchive.www.content.ContentPageGenerator;

public class FileDetails
extends ContentPageGenerator {
    public FileDetails(SimpleAddonRepository content, Path root, Path staticRoot, SiteFeatures features) {
        super(content, root, staticRoot, features);
    }

    private Map<Addon.ContentFile, List<Addon>> loadContentFiles(SimpleAddonRepository content) {
        HashMap<Addon.ContentFile, List<Addon>> contentFiles = new HashMap<Addon.ContentFile, List<Addon>>();
        content.all().forEach(c -> {
            for (Addon.ContentFile f : c.files) {
                Collection contents = contentFiles.computeIfAbsent(f, h -> new ArrayList());
                contents.add(c);
            }
        });
        return contentFiles;
    }

    @Override
    public Set<SiteMap.Page> generate() {
        Map<Addon.ContentFile, List<Addon>> contentFiles = this.loadContentFiles(this.content);
        Templates.PageSet pages = this.pageSet("content/files");
        contentFiles.entrySet().parallelStream().forEach(e -> {
            if (((List)e.getValue()).size() < 2) {
                return;
            }
            String game = ((Addon)((List)e.getValue()).getFirst()).game();
            Addon.ContentFile file = (Addon.ContentFile)e.getKey();
            Path p = this.root.resolve(Util.slug((String)game)).resolve("files").resolve(file.hash.substring(0, 2)).resolve(file.hash + ".html");
            ((List)e.getValue()).sort(Comparator.comparing(a -> a.name));
            pages.add("file.ftl", SiteMap.Page.monthly(0.25f), String.join((CharSequence)" / ", game, "Files", file.name)).put("game", game).put("file", file).put("type", FileType.forFile((String)file.name)).put("packages", e.getValue()).write(p);
        });
        return pages.pages;
    }
}

