/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.www.content;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.GameType;
import org.unrealarchive.content.addons.GameTypeRepository;
import org.unrealarchive.content.addons.SimpleAddonRepository;
import org.unrealarchive.www.Markdown;
import org.unrealarchive.www.PageGenerator;
import org.unrealarchive.www.SiteFeatures;
import org.unrealarchive.www.SiteMap;
import org.unrealarchive.www.Templates;
import org.unrealarchive.www.Thumbnails;

public class GameTypes
implements PageGenerator {
    private static final String SECTION = "Game Types & Mods";
    private static final int THUMB_WIDTH = 350;
    private final GameTypeRepository gametypes;
    private final SimpleAddonRepository content;
    private final Path root;
    private final Path staticRoot;
    private final SiteFeatures features;

    public GameTypes(GameTypeRepository gametypes, SimpleAddonRepository content, Path root, Path staticRoot, SiteFeatures features) {
        this.gametypes = gametypes;
        this.content = content;
        this.root = root;
        this.staticRoot = staticRoot;
        this.features = features;
    }

    private Map<String, Game> loadGames(GameTypeRepository gametypes) {
        TreeMap<String, Game> games = new TreeMap<String, Game>();
        gametypes.all().stream().filter(g -> !g.isVariation()).sorted().forEach(d -> {
            Game game = games.computeIfAbsent(d.game, x$0 -> new Game((String)x$0));
            game.add((GameType)d, gametypes.variations(d).stream().sorted().toList());
        });
        return games;
    }

    @Override
    public Set<SiteMap.Page> generate() {
        Map<String, Game> games = this.loadGames(this.gametypes);
        Templates.PageSet pages = new Templates.PageSet("content/gametypes", this.features, this.root, this.staticRoot);
        try {
            for (Game game : games.values()) {
                this.generateGame(pages, game);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to render gametypes page", e);
        }
        return pages.pages;
    }

    private void generateGame(Templates.PageSet pages, Game game) throws IOException {
        pages.add("game.ftl", SiteMap.Page.weekly(0.95f), String.join((CharSequence)" / ", game.name, SECTION)).put("game", game).write(game.path.resolve("index.html"));
        for (GameTypeInfo g : game.gametypes) {
            this.generateGameType(pages, g);
            for (GameTypeInfo v : g.variations) {
                this.generateGameType(pages, v);
            }
        }
    }

    private void generateGameType(Templates.PageSet pages, GameTypeInfo gametype) throws IOException {
        try (ReadableByteChannel docChan = this.gametypes.document(gametype.gametype);){
            Path outPath = Files.isDirectory(gametype.path, new LinkOption[0]) ? gametype.path : Files.createDirectories(gametype.path, new FileAttribute[0]);
            this.gametypes.writeContent(gametype.gametype, outPath);
            gametype.buildGallery(outPath);
            String page = Markdown.renderMarkdown(docChan);
            Path indexPath = gametype.variationOf == null ? gametype.indexPath : gametype.path.resolve("index.html");
            pages.add("gametype.ftl", SiteMap.Page.weekly(0.97f), String.join((CharSequence)" / ", gametype.gametype.game, SECTION, gametype.gametype.name)).put("gametype", gametype).put("page", page).write(indexPath);
            for (GameType.Release release : gametype.gametype.releases) {
                this.generateRelease(pages, gametype, release, outPath.resolve(Util.slug((String)release.title)));
            }
        }
    }

    private void generateRelease(Templates.PageSet pages, GameTypeInfo gametype, GameType.Release release, Path path) throws IOException {
        Path outPath = Files.isDirectory(path, new LinkOption[0]) ? path : Files.createDirectories(path, new FileAttribute[0]);
        pages.add("release.ftl", SiteMap.Page.monthly(0.9f), String.join((CharSequence)" / ", gametype.gametype.game, SECTION, gametype.gametype.name, release.title)).put("gametype", gametype).put("release", release).write(outPath.resolve("index.html"));
    }

    public class Game {
        public final String name;
        public final String slug;
        public final Path path;
        public final Path root;
        public final List<GameTypeInfo> gametypes = new ArrayList<GameTypeInfo>();
        public int count;

        public Game(String name) {
            this.name = name;
            this.slug = Util.slug((String)name);
            this.root = GameTypes.this.root.resolve(this.slug);
            this.path = this.root.resolve("gametypes");
            this.count = 0;
        }

        public void add(GameType g, List<GameType> variations) {
            this.gametypes.add(new GameTypeInfo(GameTypes.this, g, this, variations.stream().map(v -> new GameTypeInfo(GameTypes.this, (GameType)v, this, g)).toList()));
            ++this.count;
        }
    }

    public class GameTypeInfo {
        public final GameType gametype;
        public final Game game;
        public final GameType variationOf;
        public final List<GameTypeInfo> variations;
        public final String slug;
        public final Path path;
        public final Path indexPath;
        public final String fallbackTitle;
        public final Map<String, String> gallery;
        public final Map<String, Map<String, Integer>> filesAlsoIn;

        public GameTypeInfo(GameTypes this$0, GameType gametype, Game game, List<GameTypeInfo> variations) {
            this(this$0, gametype, game, null, variations);
        }

        public GameTypeInfo(GameTypes this$0, GameType gametype, Game game, GameType variationOf) {
            this(this$0, gametype, game, variationOf, List.of());
        }

        public GameTypeInfo(GameTypes this$0, GameType gametype, Game game, GameType variationOf, List<GameTypeInfo> variations) {
            this.gametype = gametype;
            this.game = game;
            this.slug = Util.slug((String)gametype.name);
            this.path = variationOf == null ? gametype.slugPath(this$0.root) : variationOf.slugPath(this$0.root).resolve(Util.slug((String)gametype.name));
            this.indexPath = gametype.pagePath(this$0.root);
            this.variationOf = variationOf;
            this.variations = variations;
            this.filesAlsoIn = new HashMap<String, Map<String, Integer>>();
            for (GameType.Release release : gametype.releases) {
                for (GameType.ReleaseFile file : release.files) {
                    if (file.deleted) continue;
                    Map fileMap = this.filesAlsoIn.computeIfAbsent(Util.slug((String)file.originalFilename), s -> new HashMap());
                    for (Addon.ContentFile cf : file.files) {
                        int alsoInCount = this$0.content.containingFileCount(cf.hash);
                        if (alsoInCount <= 0) continue;
                        fileMap.put(cf.hash, alsoInCount);
                    }
                }
            }
            Collections.sort(gametype.releases);
            Collections.reverse(gametype.releases);
            this.fallbackTitle = gametype.bannerImage.isBlank() ? gametype.maps.stream().filter(g -> g.screenshot != null).map(g -> g.screenshot.url).findAny().orElse("") : "";
            this.gallery = new LinkedHashMap<String, String>();
        }

        protected void buildGallery(Path outPath) {
            try {
                Path gametypePath = outPath.toAbsolutePath();
                try (Stream<Path> files = Files.list(gametypePath.resolve("gallery"));){
                    this.gallery.putAll(files.filter(f -> Files.isRegularFile(f, new LinkOption[0]) && Util.image((Path)f)).filter(f -> !f.getFileName().toString().startsWith("t_")).sorted().collect(Collectors.toMap(f -> gametypePath.relativize((Path)f).toString(), f -> {
                        try {
                            Path thumb = Thumbnails.thumbnail(f, outPath.resolve("gallery").resolve("t_" + Util.fileName((Path)f)), 350);
                            return outPath.relativize(thumb).toString();
                        }
                        catch (Exception e) {
                            return "";
                        }
                    }, (k, v) -> v, () -> new LinkedHashMap())));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

