/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.www.content;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.SimpleAddonRepository;
import org.unrealarchive.www.SiteFeatures;
import org.unrealarchive.www.SiteMap;
import org.unrealarchive.www.Templates;
import org.unrealarchive.www.content.ContentPageGenerator;

public abstract class GenericContentPage<T extends Addon>
extends ContentPageGenerator {
    static final DateTimeFormatter RELEASE_DATE_FORMAT = new DateTimeFormatterBuilder().append(DateTimeFormatter.ofPattern("yyyy-MM")).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).toFormatter();
    static final LocalDate MIN_DATE = LocalDate.of(1998, 1, 1);
    static final LocalDate MAX_DATE = LocalDate.now();

    public GenericContentPage(SimpleAddonRepository content, Path root, Path staticRoot, SiteFeatures features) {
        super(content, root, staticRoot, features);
    }

    abstract String gameSubGroup(T var1);

    String letterSubGroup(T item) {
        return item.subGrouping();
    }

    void localImages(Addon content, Path localPath) {
        if (!this.features.localImages) {
            return;
        }
        List<Addon.Attachment> images = content.attachments.stream().filter(a -> a.type == Addon.AttachmentType.IMAGE).toList();
        Path imgPath = localPath.resolve("images");
        try {
            if (!Files.exists(imgPath, new LinkOption[0])) {
                Files.createDirectories(imgPath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            System.err.printf("\rFailed to download create output directory %s: %s%n", imgPath, e);
            return;
        }
        for (Addon.Attachment img : images) {
            try {
                System.out.printf("\rDownloading image %-60s", img.name);
                String hashName = String.join((CharSequence)"_", content.hash.substring(0, 8), img.name);
                Path outPath = imgPath.resolve(Util.safeFileName((String)hashName));
                if (!Files.exists(outPath, new LinkOption[0])) {
                    Util.downloadTo((String)img.url, (Path)outPath);
                }
                content.attachments.remove(img);
                content.attachments.add(new Addon.Attachment(img.type, img.name, localPath.relativize(outPath).toString()));
            }
            catch (Throwable t) {
                System.err.printf("\rFailed to download image %s: %s%n", img.name, t);
            }
        }
    }

    public Map<Integer, Map<Integer, Integer>> timeline(Game game) {
        Map grouped = ((Stream)game.groups.values().stream().flatMap(g -> g.letters.values().stream()).flatMap(g -> g.pages.stream()).flatMap(g -> g.items.stream()).parallel()).filter(c -> c.releaseDate.isPresent()).filter(c -> c.releaseDate.get().isAfter(MIN_DATE) && c.releaseDate.get().isBefore(MAX_DATE)).collect(HashMap::new, (m, c) -> m.compute(c.releaseDate.get(), (k, v) -> v == null ? 1 : v + 1), (a, b) -> b.forEach((k, v) -> a.compute(k, (x, y) -> y == null ? v : y + v)));
        if (grouped.isEmpty()) {
            return Map.of();
        }
        LocalDate min = (LocalDate)grouped.keySet().stream().min(LocalDate::compareTo).get();
        LocalDate max = (LocalDate)grouped.keySet().stream().max(LocalDate::compareTo).get();
        TreeMap<Integer, Map<Integer, Integer>> everything = new TreeMap<Integer, Map<Integer, Integer>>();
        min.datesUntil(max.plusMonths(1L), Period.ofMonths(1)).forEachOrdered(d -> everything.compute(d.getYear(), (k, v) -> {
            Map months = v == null ? new TreeMap() : v;
            months.put(d.getMonthValue(), grouped.getOrDefault(d, 0));
            return months;
        }));
        return everything;
    }

    void generateTimeline(Templates.PageSet pages, Map<Integer, Map<Integer, Integer>> timeline, Game game, String sectionName) {
        timeline.forEach((year, months) -> {
            pages.add("months.ftl", SiteMap.Page.weekly(0.55f), String.join((CharSequence)" / ", sectionName, game.game.bigName, Integer.toString(year))).put("game", game).put("timeline", timeline).put("year", year).put("months", months).write(game.path.resolve("releases").resolve(Integer.toString(year)).resolve("index.html"));
            months.forEach((month, count) -> {
                LocalDate date = LocalDate.of((int)year, month, 1);
                pages.add("month.ftl", SiteMap.Page.weekly(0.6f), String.join((CharSequence)" / ", sectionName, game.game.bigName, Integer.toString(year), date.getMonth().toString())).put("game", game).put("timeline", timeline).put("year", year).put("month", month).put("items", game.dated.getOrDefault(date, List.of())).write(game.path.resolve("releases").resolve(Integer.toString(year)).resolve(Integer.toString(month)).resolve("index.html"));
            });
        });
    }

    GameList loadContent(Class<T> type, SimpleAddonRepository content, String sectionName) {
        GameList games = new GameList(this);
        content.get(type, false, false).stream().sorted().forEach(m -> {
            Game g = games.games.computeIfAbsent(m.game, name -> new Game((String)name, sectionName));
            if (Games.byName((String)m.game) == Games.UNREAL_TOURNAMENT_2003) {
                games.games.computeIfAbsent(Games.UNREAL_TOURNAMENT_2004.name, n -> new Game(Games.UNREAL_TOURNAMENT_2004.name, sectionName)).add(m);
            }
            g.add(m);
        });
        return games;
    }

    public class Game {
        public final Games game;
        public final String name;
        public final String slug;
        public final Path root;
        public final Path path;
        public final TreeMap<String, SubGroup> groups = new TreeMap();
        public int count;
        public final HashMap<LocalDate, List<ContentInfo>> dated;

        public Game(String name, String sectionName) {
            this.game = Games.byName((String)name);
            this.name = name;
            this.slug = Util.slug((String)name);
            this.root = GenericContentPage.this.root.resolve(this.slug);
            this.path = this.root.resolve(sectionName);
            this.count = 0;
            this.dated = new HashMap();
        }

        public ContentInfo add(T item) {
            SubGroup gametype = this.groups.computeIfAbsent(GenericContentPage.this.gameSubGroup(item), g -> new SubGroup(this, (String)g));
            ++this.count;
            ContentInfo added = gametype.add(item);
            added.releaseDate.map(r -> this.dated.computeIfAbsent((LocalDate)r, d -> new ArrayList()).add(added));
            return added;
        }
    }

    public class GameList {
        public final TreeMap<String, Game> games = new TreeMap();

        public GameList(GenericContentPage this$0) {
        }
    }

    public static class ContentInfo
    implements Comparable<ContentInfo> {
        public final Page page;
        public final String itemHash;
        private final String itemName;
        public final Path path;
        public final Collection<ContentInfo> variations;
        public final Map<String, Integer> alsoIn;
        public final Optional<LocalDate> releaseDate;
        final /* synthetic */ GenericContentPage this$0;

        public ContentInfo(Page page, T item) {
            this.this$0 = this$0;
            this.page = page;
            this.itemHash = ((Addon)item).hash;
            this.itemName = ((Addon)item).name;
            this.path = item.slugPath(this$0.root);
            this.alsoIn = new HashMap<String, Integer>();
            for (Addon.ContentFile f : ((Addon)item).files) {
                int alsoInCount = this$0.content.containingFileCount(f.hash);
                if (alsoInCount <= 1) continue;
                this.alsoIn.put(f.hash, alsoInCount - 1);
            }
            this.variations = this$0.content.variationsOf(((Addon)item).hash).stream().filter(p -> p.getClass().isAssignableFrom(item.getClass())).map(p -> new ContentInfo(this.this$0, page, p)).sorted().toList();
            this.releaseDate = item.releaseDate() != null && !item.releaseDate().equals("Unknown") ? Optional.of(LocalDate.parse(item.releaseDate(), RELEASE_DATE_FORMAT)) : Optional.empty();
        }

        public T item() {
            Addon item = this.this$0.content.forHash(this.itemHash);
            return item;
        }

        @Override
        public int compareTo(ContentInfo o) {
            return this.itemName.toLowerCase().compareTo(o.itemName.toLowerCase());
        }
    }

    public class Page {
        public final LetterGroup letter;
        public final int number;
        public final Path path;
        public final List<ContentInfo> items = new ArrayList<ContentInfo>(150);

        public Page(LetterGroup letter, int number) {
            this.letter = letter;
            this.number = number;
            this.path = letter.path.resolve(Integer.toString(number));
        }

        public ContentInfo add(T item) {
            ContentInfo added = new ContentInfo(GenericContentPage.this, this, item);
            this.items.add(added);
            Collections.sort(this.items);
            return added;
        }
    }

    public class LetterGroup {
        public final SubGroup group;
        public final String letter;
        public final Path path;
        public final List<Page> pages = new ArrayList<Page>();
        public int count;

        public LetterGroup(SubGroup group, String letter) {
            this.group = group;
            this.letter = letter;
            this.path = group.path.resolve(letter);
            this.count = 0;
        }

        public ContentInfo add(T item) {
            if (this.pages.isEmpty()) {
                this.pages.add(new Page(this, 1));
            }
            Page page = this.pages.getLast();
            if (page.items.size() == 150) {
                page = new Page(this, this.pages.size() + 1);
                this.pages.add(page);
            }
            ++this.count;
            return page.add(item);
        }
    }

    public class SubGroup {
        public final Game game;
        public final String name;
        public final String slug;
        public final Path path;
        public final TreeMap<String, LetterGroup> letters = new TreeMap();
        public int count;

        public SubGroup(Game game, String name) {
            this.game = game;
            this.name = name;
            this.slug = Util.slug((String)name);
            this.path = game.path.resolve(this.slug);
            this.count = 0;
        }

        public ContentInfo add(T item) {
            LetterGroup letter = this.letters.computeIfAbsent(GenericContentPage.this.letterSubGroup(item), l -> new LetterGroup(this, (String)l));
            ++this.count;
            return letter.add(item);
        }
    }
}

