/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.www.content;

import java.nio.file.Path;
import java.time.LocalDate;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.ContentEntity;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.addons.GameTypeRepository;
import org.unrealarchive.content.addons.SimpleAddonRepository;
import org.unrealarchive.content.managed.ManagedContentRepository;
import org.unrealarchive.www.SiteFeatures;
import org.unrealarchive.www.SiteMap;
import org.unrealarchive.www.Templates;
import org.unrealarchive.www.content.ContentPageGenerator;

public class Latest
extends ContentPageGenerator {
    private final Path sectionRoot;
    private final GameTypeRepository gameTypes;
    private final ManagedContentRepository managed;

    public Latest(SimpleAddonRepository content, GameTypeRepository gameTypes, ManagedContentRepository managed, Path root, Path staticRoot, SiteFeatures features) {
        super(content, root, staticRoot, features);
        this.sectionRoot = root.resolve("latest");
        this.gameTypes = gameTypes;
        this.managed = managed;
    }

    private Set<ContentEntity<?>> loadAllContent(SimpleAddonRepository content, GameTypeRepository gameTypes, ManagedContentRepository managed) {
        return Stream.concat(Stream.concat(content.all(false).stream(), gameTypes.all().stream()), managed.all().stream().filter(d -> d.published)).collect(Collectors.toSet());
    }

    @Override
    public Set<SiteMap.Page> generate() {
        Set<ContentEntity<?>> allContent = this.loadAllContent(this.content, this.gameTypes, this.managed);
        TreeMap<LocalDate, List<ContentEntity>> contentFiles = new TreeMap<LocalDate, List<ContentEntity>>(allContent.stream().sorted((a, b) -> -a.addedDate().compareTo(b.addedDate())).collect(Collectors.groupingBy(c -> c.addedDate().toLocalDate())));
        Templates.PageSet pages = this.pageSet("content/latest");
        pages.add("index.ftl", SiteMap.Page.weekly(0.97f), "Latest Content Additions").put("latest", contentFiles.descendingMap()).write(this.sectionRoot.resolve("index.html"));
        pages.add("feed.ftl", SiteMap.Page.weekly(0.0f), "Latest Content Additions").put("latest", contentFiles.descendingMap()).write(this.sectionRoot.resolve("feed.xml"));
        for (Games game : Games.values()) {
            TreeMap<LocalDate, List<ContentEntity>> gameContent = new TreeMap<LocalDate, List<ContentEntity>>(allContent.stream().filter(c -> c.game().equals(game.name)).sorted((a, b) -> -a.addedDate().compareTo(b.addedDate())).collect(Collectors.groupingBy(c -> c.addedDate().toLocalDate())));
            pages.add("feed.ftl", SiteMap.Page.weekly(0.0f), "Latest " + game.name + " Additions").put("latest", gameContent.descendingMap()).write(this.sectionRoot.resolve(Util.slug((String)game.name) + ".xml"));
        }
        return pages.pages;
    }
}

