/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.www.content;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.GameType;
import org.unrealarchive.content.addons.GameTypeRepository;
import org.unrealarchive.content.addons.MapPack;
import org.unrealarchive.content.addons.SimpleAddonRepository;
import org.unrealarchive.www.SiteFeatures;
import org.unrealarchive.www.SiteMap;
import org.unrealarchive.www.Templates;
import org.unrealarchive.www.content.GenericContentPage;

public class MapPacks
extends GenericContentPage<MapPack> {
    private static final String SECTION = "Map Packs";
    private static final String LETTER_SUBGROUP = "all";
    private final GameTypeRepository gametypes;
    private final Map<Integer, GameType> gameTypeCache = new ConcurrentHashMap<Integer, GameType>();

    public MapPacks(SimpleAddonRepository content, Path root, Path staticRoot, SiteFeatures features, GameTypeRepository gametypes) {
        super(content, root, staticRoot, features);
        this.gametypes = gametypes;
    }

    @Override
    public Set<SiteMap.Page> generate() {
        GenericContentPage.GameList games = this.loadContent(MapPack.class, this.content, "mappacks");
        Templates.PageSet pages = this.pageSet("content/mappacks");
        games.games.entrySet().parallelStream().forEach(g -> {
            Map<Integer, Map<Integer, Integer>> timeline = this.timeline((GenericContentPage.Game)g.getValue());
            Games game = Games.byName((String)((String)g.getKey()));
            pages.add("gametypes.ftl", SiteMap.Page.monthly(0.62f), String.join((CharSequence)" / ", game.bigName, SECTION)).put("game", g.getValue()).put("timeline", timeline).write(((GenericContentPage.Game)g.getValue()).path.resolve("index.html"));
            ((GenericContentPage.Game)g.getValue()).groups.entrySet().parallelStream().forEach(gt -> {
                GameType gtInfo = this.gameTypeCache.computeIfAbsent(Objects.hash(((GenericContentPage.Game)g.getValue()).game.name.toLowerCase(), ((GenericContentPage.SubGroup)gt.getValue()).name.toLowerCase()), k -> this.gametypes.findGametype(((GenericContentPage.Game)g.getValue()).game, ((GenericContentPage.SubGroup)gt.getValue()).name));
                ((GenericContentPage.SubGroup)gt.getValue()).letters.get((Object)LETTER_SUBGROUP).pages.parallelStream().forEach(p -> {
                    if (((GenericContentPage.SubGroup)gt.getValue()).letters.get((Object)LETTER_SUBGROUP).pages.size() > 1) {
                        pages.add("listing.ftl", SiteMap.Page.weekly(0.65f), String.join((CharSequence)" / ", game.bigName, SECTION, (CharSequence)gt.getKey())).put("page", p).put("pages", ((GenericContentPage.SubGroup)gt.getValue()).letters.get((Object)LETTER_SUBGROUP).pages).put("gametype", gt.getValue()).put("gameTypeInfo", gtInfo).put("gameTypeInfoPath", gtInfo != null ? gtInfo.slugPath(this.root) : null).write(p.path.resolve("index.html"));
                    }
                    p.items.parallelStream().forEach(pack -> this.packPage(pages, (GenericContentPage.ContentInfo)pack));
                });
                pages.add("listing.ftl", SiteMap.Page.weekly(0.65f), String.join((CharSequence)" / ", game.bigName, SECTION, (CharSequence)gt.getKey())).put("page", ((GenericContentPage.SubGroup)gt.getValue()).letters.get((Object)LETTER_SUBGROUP).pages.getFirst()).put("pages", ((GenericContentPage.SubGroup)gt.getValue()).letters.get((Object)LETTER_SUBGROUP).pages).put("gametype", gt.getValue()).put("gameTypeInfo", gtInfo).put("gameTypeInfoPath", gtInfo != null ? gtInfo.slugPath(this.root) : null).write(((GenericContentPage.SubGroup)gt.getValue()).path.resolve("index.html"));
            });
            this.generateTimeline(pages, timeline, (GenericContentPage.Game)g.getValue(), SECTION);
        });
        return pages.pages;
    }

    private void packPage(Templates.PageSet pages, GenericContentPage.ContentInfo pack) {
        MapPack item = (MapPack)pack.item();
        GameType gt = this.gameTypeCache.computeIfAbsent(Objects.hash(item.game.toLowerCase(), item.gametype.toLowerCase()), k -> this.gametypes.findGametype(Games.byName((String)item.game), item.gametype));
        this.localImages((Addon)item, pack.path.getParent());
        pages.add("mappack.ftl", SiteMap.Page.monthly(0.9f, item.firstIndex), String.join((CharSequence)" / ", pack.page.letter.group.game.game.bigName, SECTION, pack.page.letter.group.name, item.name)).put("pack", pack).put("gameTypeInfo", gt).put("gameTypeInfoPath", gt != null ? gt.slugPath(this.root) : null).write(Paths.get(String.valueOf(pack.path) + ".html", new String[0]));
        for (GenericContentPage.ContentInfo variation : pack.variations) {
            this.packPage(pages, variation);
        }
    }

    @Override
    protected String gameSubGroup(MapPack item) {
        return item.gametype;
    }

    @Override
    protected String letterSubGroup(MapPack item) {
        return LETTER_SUBGROUP;
    }
}

