/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.www.content;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.GameType;
import org.unrealarchive.content.addons.GameTypeRepository;
import org.unrealarchive.content.addons.SimpleAddonRepository;
import org.unrealarchive.www.SiteFeatures;
import org.unrealarchive.www.SiteMap;
import org.unrealarchive.www.Templates;
import org.unrealarchive.www.content.GenericContentPage;

public class Maps
extends GenericContentPage<org.unrealarchive.content.addons.Map> {
    private static final String SECTION = "Maps";
    private final GameTypeRepository gametypes;
    private final Map<Integer, GameType> gameTypeCache = new ConcurrentHashMap<Integer, GameType>();

    public Maps(SimpleAddonRepository content, Path root, Path staticRoot, SiteFeatures features, GameTypeRepository gametypes) {
        super(content, root, staticRoot, features);
        this.gametypes = gametypes;
    }

    @Override
    public Set<SiteMap.Page> generate() {
        GenericContentPage.GameList games = this.loadContent(org.unrealarchive.content.addons.Map.class, this.content, "maps");
        Templates.PageSet pages = this.pageSet("content/maps");
        games.games.entrySet().parallelStream().forEach(g -> {
            Map<Integer, Map<Integer, Integer>> timeline = this.timeline((GenericContentPage.Game)g.getValue());
            Games game = Games.byName((String)((String)g.getKey()));
            pages.add("gametypes.ftl", SiteMap.Page.monthly(0.62f), String.join((CharSequence)" / ", game.bigName, SECTION)).put("game", g.getValue()).put("timeline", timeline).write(((GenericContentPage.Game)g.getValue()).path.resolve("index.html"));
            ((GenericContentPage.Game)g.getValue()).groups.entrySet().parallelStream().forEach(gt -> {
                GameType gtInfo = this.gameTypeCache.computeIfAbsent(Objects.hash(((GenericContentPage.Game)g.getValue()).game.name.toLowerCase(), ((GenericContentPage.SubGroup)gt.getValue()).name.toLowerCase()), k -> this.gametypes.findGametype(((GenericContentPage.Game)g.getValue()).game, ((GenericContentPage.SubGroup)gt.getValue()).name));
                if (((GenericContentPage.SubGroup)gt.getValue()).count < 150) {
                    List all = ((GenericContentPage.SubGroup)gt.getValue()).letters.values().stream().flatMap(l -> l.pages.stream()).flatMap(e -> e.items.stream()).sorted().toList();
                    pages.add("listing.ftl", SiteMap.Page.weekly(0.65f), String.join((CharSequence)" / ", game.bigName, SECTION, (CharSequence)gt.getKey())).put("gametype", gt.getValue()).put("maps", all).put("gameTypeInfo", gtInfo).put("gameTypeInfoPath", gtInfo != null ? gtInfo.slugPath(this.root) : null).write(((GenericContentPage.SubGroup)gt.getValue()).path.resolve("index.html"));
                    all.parallelStream().forEach(map -> this.mapPage(pages, (GenericContentPage.ContentInfo)map));
                    return;
                }
                ((GenericContentPage.SubGroup)gt.getValue()).letters.entrySet().parallelStream().forEach(l -> {
                    ((GenericContentPage.LetterGroup)l.getValue()).pages.parallelStream().forEach(p -> {
                        pages.add("listing.ftl", SiteMap.Page.weekly(0.65f), String.join((CharSequence)" / ", game.bigName, SECTION, (CharSequence)gt.getKey())).put("page", p).put("gameTypeInfo", gtInfo).put("gameTypeInfoPath", gtInfo != null ? gtInfo.slugPath(this.root) : null).write(p.path.resolve("index.html"));
                        p.items.parallelStream().forEach(map -> this.mapPage(pages, (GenericContentPage.ContentInfo)map));
                    });
                    pages.add("listing.ftl", SiteMap.Page.weekly(0.65f), String.join((CharSequence)" / ", game.bigName, SECTION, (CharSequence)gt.getKey())).put("page", ((GenericContentPage.LetterGroup)l.getValue()).pages.getFirst()).put("gameTypeInfo", gtInfo).put("gameTypeInfoPath", gtInfo != null ? gtInfo.slugPath(this.root) : null).write(((GenericContentPage.LetterGroup)l.getValue()).path.resolve("index.html"));
                });
                pages.add("listing.ftl", SiteMap.Page.weekly(0.65f), String.join((CharSequence)" / ", game.bigName, SECTION, (CharSequence)gt.getKey())).put("page", ((GenericContentPage.SubGroup)gt.getValue()).letters.firstEntry().getValue().pages.getFirst()).put("gameTypeInfo", gtInfo).put("gameTypeInfoPath", gtInfo != null ? gtInfo.slugPath(this.root) : null).write(((GenericContentPage.SubGroup)gt.getValue()).path.resolve("index.html"));
            });
            this.generateTimeline(pages, timeline, (GenericContentPage.Game)g.getValue(), SECTION);
        });
        return pages.pages;
    }

    private void mapPage(Templates.PageSet pages, GenericContentPage.ContentInfo map) {
        org.unrealarchive.content.addons.Map item = (org.unrealarchive.content.addons.Map)map.item();
        GameType gtInfo = this.gameTypeCache.computeIfAbsent(Objects.hash(item.game.toLowerCase(), item.gametype.toLowerCase()), k -> this.gametypes.findGametype(Games.byName((String)item.game), item.gametype));
        this.localImages((Addon)item, this.root.resolve(map.path).getParent());
        pages.add("map.ftl", SiteMap.Page.monthly(0.9f, item.firstIndex), String.join((CharSequence)" / ", map.page.letter.group.game.game.bigName, SECTION, map.page.letter.group.name, item.title)).put("map", map).put("gameTypeInfo", gtInfo).put("gameTypeInfoPath", gtInfo != null ? gtInfo.slugPath(this.root) : null).write(item.pagePath(this.root));
        for (GenericContentPage.ContentInfo variation : map.variations) {
            this.mapPage(pages, variation);
        }
    }

    @Override
    protected String gameSubGroup(org.unrealarchive.content.addons.Map item) {
        return item.gametype;
    }
}

