/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.www.content;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.Mutator;
import org.unrealarchive.content.addons.SimpleAddonRepository;
import org.unrealarchive.www.SiteFeatures;
import org.unrealarchive.www.SiteMap;
import org.unrealarchive.www.Templates;
import org.unrealarchive.www.content.GenericContentPage;

public class Mutators
extends GenericContentPage<Mutator> {
    private static final String SECTION = "Mutators";
    private static final String SUBGROUP = "all";

    public Mutators(SimpleAddonRepository content, Path root, Path staticRoot, SiteFeatures localImages) {
        super(content, root, staticRoot, localImages);
    }

    @Override
    public Set<SiteMap.Page> generate() {
        GenericContentPage.GameList games = this.loadContent(Mutator.class, this.content, "mutators");
        Templates.PageSet pages = this.pageSet("content/mutators");
        games.games.entrySet().parallelStream().forEach(g -> {
            Map<Integer, Map<Integer, Integer>> timeline = this.timeline((GenericContentPage.Game)g.getValue());
            Games game = Games.byName((String)((String)g.getKey()));
            if (((GenericContentPage.Game)g.getValue()).count < 150) {
                List all = ((GenericContentPage.Game)g.getValue()).groups.get((Object)SUBGROUP).letters.values().stream().flatMap(l -> l.pages.stream()).flatMap(e -> e.items.stream()).sorted().toList();
                pages.add("listing.ftl", SiteMap.Page.weekly(0.65f), String.join((CharSequence)" / ", game.bigName, SECTION)).put("game", g.getValue()).put("timeline", timeline).put("mutators", all).write(((GenericContentPage.Game)g.getValue()).path.resolve("index.html"));
                all.parallelStream().forEach(mutator -> this.mutatorPage(pages, (GenericContentPage.ContentInfo)mutator));
                this.generateTimeline(pages, timeline, (GenericContentPage.Game)g.getValue(), SECTION);
                return;
            }
            ((GenericContentPage.Game)g.getValue()).groups.get((Object)SUBGROUP).letters.entrySet().parallelStream().forEach(l -> {
                ((GenericContentPage.LetterGroup)l.getValue()).pages.parallelStream().forEach(p -> {
                    pages.add("listing.ftl", SiteMap.Page.weekly(0.65f), String.join((CharSequence)" / ", game.bigName, SECTION)).put("timeline", timeline).put("page", p).write(p.path.resolve("index.html"));
                    p.items.parallelStream().forEach(mutator -> this.mutatorPage(pages, (GenericContentPage.ContentInfo)mutator));
                });
                pages.add("listing.ftl", SiteMap.Page.weekly(0.65f), String.join((CharSequence)" / ", game.bigName, SECTION)).put("timeline", timeline).put("page", ((GenericContentPage.LetterGroup)l.getValue()).pages.getFirst()).write(((GenericContentPage.LetterGroup)l.getValue()).path.resolve("index.html"));
            });
            pages.add("listing.ftl", SiteMap.Page.weekly(0.65f), String.join((CharSequence)" / ", game.bigName, SECTION)).put("timeline", timeline).put("page", ((GenericContentPage.Game)g.getValue()).groups.get((Object)SUBGROUP).letters.firstEntry().getValue().pages.getFirst()).write(((GenericContentPage.Game)g.getValue()).path.resolve("index.html"));
            this.generateTimeline(pages, timeline, (GenericContentPage.Game)g.getValue(), SECTION);
        });
        return pages.pages;
    }

    private void mutatorPage(Templates.PageSet pages, GenericContentPage.ContentInfo mutator) {
        Object item = mutator.item();
        this.localImages((Addon)item, this.root.resolve(mutator.path).getParent());
        pages.add("mutator.ftl", SiteMap.Page.monthly(0.9f, ((Addon)item).firstIndex), String.join((CharSequence)" / ", mutator.page.letter.group.game.game.bigName, SECTION, ((Addon)item).name)).put("mutator", mutator).write(Paths.get(String.valueOf(mutator.path) + ".html", new String[0]));
        for (GenericContentPage.ContentInfo variation : mutator.variations) {
            this.mutatorPage(pages, variation);
        }
    }

    @Override
    protected String gameSubGroup(Mutator item) {
        return SUBGROUP;
    }
}

