/*
 * Decompiled with CFR 0.152.
 */
package org.unrealarchive.www.content;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.unrealarchive.common.Util;
import org.unrealarchive.content.ContentEntity;
import org.unrealarchive.content.FileType;
import org.unrealarchive.content.Games;
import org.unrealarchive.content.addons.Addon;
import org.unrealarchive.content.addons.GameTypeRepository;
import org.unrealarchive.content.addons.SimpleAddonRepository;
import org.unrealarchive.content.managed.ManagedContentRepository;
import org.unrealarchive.www.SiteFeatures;
import org.unrealarchive.www.SiteMap;
import org.unrealarchive.www.Templates;
import org.unrealarchive.www.content.ContentPageGenerator;

public class Packages
extends ContentPageGenerator {
    private static final Set<String> PKG_TYPES = Arrays.stream(FileType.PACKAGES).filter(p -> p != FileType.MAP).flatMap(p -> p.ext.stream()).collect(Collectors.toSet());
    private final GameTypeRepository gameTypes;
    private final ManagedContentRepository managed;

    public Packages(SimpleAddonRepository content, GameTypeRepository gameTypes, ManagedContentRepository managed, Path root, Path staticRoot, SiteFeatures features) {
        super(content, root, staticRoot, features);
        this.gameTypes = gameTypes;
        this.managed = managed;
    }

    public static Map<Games, Map<String, Map<Addon.ContentFile, List<ContentEntity<?>>>>> loadContentFiles(SimpleAddonRepository content, GameTypeRepository gameTypes) {
        HashMap contentFiles = new HashMap();
        content.all().forEach(c -> {
            for (Addon.ContentFile f : c.files) {
                if (!PKG_TYPES.contains(Util.extension((String)f.name).toLowerCase())) continue;
                String pkgName = Util.plainName((String)f.name).toLowerCase();
                contentFiles.computeIfAbsent(Games.byName((String)c.game), g -> new HashMap()).computeIfAbsent(pkgName, p -> new HashMap()).computeIfAbsent(f, fc -> new ArrayList()).add(c);
            }
        });
        gameTypes.all().forEach(g -> g.releases.forEach(r -> r.files.forEach(c -> {
            for (Addon.ContentFile f : c.files) {
                if (!PKG_TYPES.contains(Util.extension((String)f.name).toLowerCase())) continue;
                String pkgName = Util.plainName((String)f.name).toLowerCase();
                contentFiles.computeIfAbsent(Games.byName((String)g.game), n -> new HashMap()).computeIfAbsent(pkgName, p -> new HashMap()).computeIfAbsent(f, fc -> new ArrayList()).add(g);
            }
        })));
        return contentFiles;
    }

    @Override
    public Set<SiteMap.Page> generate() {
        Map<Games, Map<String, Map<Addon.ContentFile, List<ContentEntity<?>>>>> contentFiles = Packages.loadContentFiles(this.content, this.gameTypes);
        Templates.PageSet pages = this.pageSet("content/packages");
        contentFiles.entrySet().parallelStream().forEach(game -> ((Map)game.getValue()).entrySet().parallelStream().forEach(e -> {
            Path p = this.root.resolve(Util.slug((String)((Games)game.getKey()).name)).resolve("packages").resolve(Util.authorSlug((String)((String)e.getKey()))).resolve("index.html");
            LinkedHashMap sorted = ((Map)e.getValue()).entrySet().stream().sorted(Collections.reverseOrder(Comparator.comparingInt(a -> ((List)a.getValue()).size()))).peek(a -> Collections.sort((List)a.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
            pages.add("package.ftl", SiteMap.Page.monthly(0.3f), String.join((CharSequence)" / ", ((Games)game.getKey()).name, "Packages", (CharSequence)e.getKey())).put("game", ((Games)game.getKey()).name).put("package", e.getKey()).put("packageFiles", sorted).write(p);
        }));
        return pages.pages;
    }
}

